% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCRAData.R
\name{getPCRAData}
\alias{getPCRAData}
\title{Download CRSP and SPGMI Data}
\usage{
getPCRAData(dataset = "stocksCRSPweekly", cache = TRUE, refresh = FALSE)
}
\arguments{
\item{dataset}{a valid dataset name (see details)}

\item{cache}{logical variable controlling whether or not to cache the data so
that when calling the function for the same dataset it will be loaded from cache
rather than re-downloading from the github site}

\item{refresh}{logical variable controlling whether or not to re-download a
cached dataset}
}
\value{
An object of class \dQuote{data.table}.
}
\description{
Downloads stocksCRSPweekly, stocksCRSPdaily
}
\details{
The following are valid names of datasets available:
\itemize{
\item{"stocksCRSPdaily"}{"Details same as for stocksCRSP except now daily"}
\item{"stocksCRSPweekly"}{"Details same as for stocksCRSP except now weekly"}
}
User must install R.cache package
}
\examples{
\donttest{
stocksCRSPweekly <- getPCRAData(data = "stocksCRSPweekly")
class(stocksCRSPweekly)
names(stocksCRSPweekly)

stocksCRSPdaily <- getPCRAData(data = "stocksCRSPdaily")
class(stocksCRSPdaily)
names(stocksCRSPdaily)
}
}
