% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/36_STEP_RPCr.R
\name{stepRPCr}
\alias{stepRPCr}
\title{Stepwise regression based on risk profile concept and raw risk factors}
\usage{
stepRPCr(
  start.model,
  risk.profile,
  p.value = 0.05,
  db,
  check.start.model = TRUE,
  offset.vals = NULL
)
}
\arguments{
\item{start.model}{Formula class that represents the starting model. It can include some risk factors, but it can be
defined only with intercept (\code{y ~ 1} where \code{y} is target variable).}

\item{risk.profile}{Data frame with defined risk profile. It has to contain the following columns: \code{rf} and
\code{group}. Column \code{group} defines order of groups that will be tested first as a candidate
for the regression model. Risk factors selected in each group are kept as a starting variables
for the next group testing. Column \code{rf} contains all candidate risk factors supplied for testing.}

\item{p.value}{Significance level of p-value of the estimated coefficients. For numerical risk factors this value is
is directly compared to the p-value of the estimated coefficients, while for categorical risk factors
multiple Wald test is employed and its value is used for comparison with selected threshold (\code{p.value}).}

\item{db}{Modeling data with risk factors and target variable. All risk factors (apart from the risk factors from the starting model)
should be categorized and as of character type.}

\item{check.start.model}{Logical (\code{TRUE} or \code{FALSE}), if risk factors from the starting model should
checked for p-value and trend in stepwise process.}

\item{offset.vals}{This can be used to specify an a priori known component to be included in the linear predictor during fitting.
This should be \code{NULL} or a numeric vector of length equal to the number of cases. Default is \code{NULL}.}
}
\value{
The command \code{stepRPCr} returns a list of four objects.\cr
The first object (\code{model}), is the final model, an object of class inheriting from \code{"glm"}.\cr
The second object (\code{steps}), is the data frame with risk factors selected at each iteration.\cr
The third object (\code{warnings}), is the data frame with warnings if any observed.
The warnings refer to the following checks: if risk factor has more than 10 modalities or
if any of the bins (groups) has less than 5\% of observations.\cr
The final, fourth, object \code{dev.db} returns the model development database.
}
\description{
\code{stepRPCr} customized stepwise regression with p-value and trend check on raw risk factors which additionally takes into account
the order of supplied risk factors per group when selects a candidate for the final regression model. Trend check is performed
comparing observed trend between target and analyzed risk factor and trend of the estimated coefficients.
Note that procedure checks the column names of supplied \code{db} data frame therefore some
renaming (replacement of special characters) is possible to happen. For details, please, check the help example.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#create risk factor priority groups
rf.all <- names(loans)[-1]
set.seed(6422)
rf.pg <- data.frame(rf = rf.all, group = sample(1:3, length(rf.all), rep = TRUE))
rf.pg <- rf.pg[order(rf.pg$group), ]
head(rf.pg)
res <- stepRPCr(start.model = Creditability ~ 1, 
               risk.profile = rf.pg, 
               p.value = 0.05, 
               db = loans)
summary(res$model)$coefficients
res$steps
head(res$dev.db)
}
