% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_complementary_functions.R
\name{image.pep}
\alias{image.pep}
\title{Heatmap for top models}
\usage{
\method{image}{pep}(x, n.models = 20, ...)
}
\arguments{
\item{x}{An object of class pep (e.g. output of \code{full_enumeration_pep} 
or \code{mc3_pep}).}

\item{n.models}{Positive integer, number of models to be shown on the 
heatmap. Default value=20.}

\item{...}{Additional parameters to be passed to \code{heatmap}.}
}
\value{
No return value, used for generating a heatmap.
}
\description{
Generates a heatmap where the rows correspond to the (top) models
and the columns to the input/explanatory variables. The value depicted
in cell (i,j) corresponds to the posterior inclusion probability of variable i if this
is included in model j and 0 otherwise.
}
\details{
The number of models to be displayed on the heatmap is computed as the minimum
between the number asked by the user and the number of models present in
the object \code{x}.

The color code is as follows: the darker the blue in the figure, the 
higher the posterior inclusion probability is, while white means that the 
variable is not included in the model.

In the special case of no explanatory variables, no heatmap is produced
and a message is printed.
}
\examples{
data(UScrime_data)
y <- UScrime_data[,"y"]
X <- UScrime_data[,-15]
set.seed(123)
resu <- mc3_pep(X,y,beta.binom=FALSE,itermc3=5000)
image(resu)
image(resu,n.models=10)

}
\seealso{
\code{\link{plot.pep}}
}
