% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survregpredict.R
\name{survregpredict}
\alias{survregpredict}
\title{Fit survival probabilties from a survreg object.}
\usage{
survregpredict(fit, newdata, time)
}
\arguments{
\item{fit}{a survreg object.  This should not contain strata().  It also must use the log transformation.}

\item{newdata}{a new data set with covariates from the fit.}

\item{time}{a time value (on the original, and not log, scale).}
}
\description{
Fit survival probabilties from a survreg object.
}
\examples{
#Fit the survival probability for an individual with extent 1 and
#differentiation 2 at 700 days from a Weibull regression using the 
#colon cancer data set distributed as part of the survival package.
fit<-survreg(Surv(time,status)~factor(extent)+differ,data=colon)
survregpredict(fit,data.frame(extent=1,differ=2),700)
}
