% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.simple.R
\name{pk.calc.aucpext}
\alias{pk.calc.aucpext}
\title{Calculate the AUC percent extrapolated}
\usage{
pk.calc.aucpext(auclast, aucinf)
}
\arguments{
\item{auclast}{the area under the curve from time 0 to the last 
measurement above the limit of quantification}

\item{aucinf}{the area under the curve from time 0 to infinity}
}
\value{
The numeric value of the AUC percent extrapolated or 
  \code{NA_real_} if andy of the following are true 
  \code{is.na(aucinf)}, \code{is.na(auclast)}, \code{aucinf <= 0},
  or \code{auclast <= 0}.
}
\description{
Calculate the AUC percent extrapolated
}
\details{
aucpext is \code{100*(1-auclast/aucinf)}.
}
