% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{write_nonmem}
\alias{write_nonmem}
\title{easily write a csv file compatible with nonmem}
\usage{
write_nonmem(x, file, sep = ",", row.names = FALSE, na = ".",
  quote = FALSE, ...)
}
\arguments{
\item{x}{dataframe to be written to csv}

\item{file}{character string naming a file or connection open for writing.}

\item{sep}{field string separator, defaults to comma (",")}

\item{row.names}{logical value whether to include row names}

\item{na}{value for NA}

\item{quote}{whether character or factor columns should be surrounded by double quotes}

\item{...}{remaining arguments passed to data.table::fwrite}
}
\description{
easily write a csv file compatible with nonmem
}
\details{
nonmem uses '.' for NA values, does not like quotes in column names
and does not handle row names, so these are all presets
}
\examples{
\dontrun{
write_nonmem(nonmemdat, 'folder/nonmemdat.csv')
}
}
