% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetwork.R
\name{PLNnetwork}
\alias{PLNnetwork}
\title{Poisson lognormal model towards sparse network inference}
\usage{
PLNnetwork(
  formula,
  data,
  subset,
  weights,
  penalties = NULL,
  control_init = list(),
  control_main = list()
)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{an optional vector of observation weights to be used in the fitting process.}

\item{penalties}{an optional vector of positive real number controlling the level of sparsity of the underlying network. if NULL (the default), will be set internally. See \code{control_init} and \code{control_main} options for additional tuning of the penalty.}

\item{control_init}{a list for controlling the optimization of the PLN model used at initialization, and how the vector of \code{penalties} is generated. See details.}

\item{control_main}{a list for controlling the main optimization process. Can be used to specify adaptive penalty weights. See details.}
}
\value{
an R6 object with class \code{\link{PLNnetworkfamily}}, which contains
a collection of models with class \code{\link{PLNnetworkfit}}
}
\description{
Fit the sparse inverse covariance variant of the Poisson lognormal with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets).
}
\details{
The list of parameters \code{control_main} controls the optimization of the main process, with the following entries:
\itemize{
\item "ftol_rel" stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 1e-6 when n < p, 1e-8 otherwise.
\item "ftol_abs" stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 0
\item "xtol_rel" stop when an optimization step changes every parameters by less than xtol_rel multiplied by the absolute value of the parameter. Default is 1e-4
\item "xtol_abs" stop when an optimization step changes every parameters by less than xtol_abs. Default is 0
\item "maxeval" stop when the number of iteration exceeds maxeval. Default is 10000
\item "algorithm" the optimization method used by NLOPT among LD type, i.e. "CCSAQ", "MMA", "LBFGS",
"VAR1", "VAR2". See NLOPT documentation for further details. Default is "CCSAQ".
\item "trace" integer for verbosity. Useless when \code{cores > 1}
\item "ftol_out" outer solver stops when an optimization step changes the objective function by less than xtol multiply by the absolute value of the parameter. Default is 1e-6
\item "maxit_out" outer solver stops when the number of iteration exceeds out.maxit. Default is 50
\item "penalize_diagonal" boolean: should the diagonal terms be penalized in the graphical-Lasso? Default is TRUE
\item "penalty_weights" p x p matrix of weights (default filled with 1) to adapt the amount of shrinkage to each pairs of node. Must be symmetric with positive values.
}

The list of parameters \code{control_init} controls the optimization process in the initialization and in the function \code{\link[=PLN]{PLN()}}, plus two additional parameters:
\itemize{
\item "nPenalties" an integer that specified the number of values for the penalty grid when internally generated. Ignored when penalties is non \code{NULL}
\item "min.ratio" the penalty grid ranges from the minimal value that produces a sparse to this value multiplied by \code{min.ratio}. Default is 0.1.
}
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
}
\seealso{
The classes \code{\link{PLNnetworkfamily}} and \code{\link{PLNnetworkfit}}
}
