% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-S3methods.R
\name{extract_probs}
\alias{extract_probs}
\title{Extract edge selection frequency in bootstrap subsamples}
\usage{
extract_probs(
  Robject,
  penalty = NULL,
  index = NULL,
  crit = c("StARS", "BIC", "EBIC"),
  format = c("matrix", "vector"),
  tol = 1e-05
)
}
\arguments{
\item{Robject}{an object with class PLNnetworkfamily, i.e. an output from \code{\link{PLNnetwork}}}

\item{penalty}{penalty used for the boostrap subsamples}

\item{index}{Integer index of the model to be returned. Only the first value is taken into account.}

\item{crit}{a character for the criterion used to performed the selection. Either
"BIC", "ICL", "EBIC", "StARS", "R_squared". Default is \code{ICL} for PLNPCA, and \code{BIC} for PLNnetwork.
 If StARS (Stability Approach to Regularization Selection) is chosen and stability selection
 was not yet performed, the function will call the method stability_selection with default argument.}

\item{format}{output format. Either a matrix (default) or a named vector.}

\item{tol}{tolerance for rounding error when comparing penalties.}
}
\value{
Either a matrix or named vector of edge-wise probabilities. In the latter case, edge names follow igraph convention.
}
\description{
Extracts edge selection frequency in networks reconstructed from bootstrap subsamples
during the stars stability selection procedure, as either a matrix or a named vector. In the latter
case, edge names follow igraph naming convention.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
nets <- PLNnetwork(Abundance ~ 1 + offset(log(Offset)), data = trichoptera)
\dontrun{
stability_selection(nets)
probs <- extract_probs(nets, crit = "StARS", format = "vector")
probs
}

\dontrun{
## Add edge attributes to graph using igraph
net_stars <- getBestModel(nets, "StARS")
g <- plot(net_stars, type = "partial_cor", plot=F)
library(igraph)
E(g)$prob <- probs[as_ids(E(g))]
g
}

}
