% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixturefit-S3methods.R
\name{predict.PLNmixturefit}
\alias{predict.PLNmixturefit}
\title{Prediction for a \code{\link{PLNmixturefit}} object}
\usage{
\method{predict}{PLNmixturefit}(
  object,
  newdata,
  type = c("posterior", "response", "position"),
  prior = matrix(rep(1/object$k, object$k), nrow(newdata), object$k, byrow = TRUE),
  control = PLNmixture_param(),
  ...
)
}
\arguments{
\item{object}{an R6 object with class \code{\link{PLNmixturefit}}}

\item{newdata}{A data frame in which to look for variables, offsets and counts with which to predict.}

\item{type}{The type of prediction required. The default \code{posterior} are posterior probabilities for each group ,
\code{response} is the group with maximal posterior probability and \code{latent} is the averaged latent in the latent space,
with weights equal to the posterior probabilities.}

\item{prior}{User-specified prior group probabilities in the new data. The default uses a uniform prior.}

\item{control}{a list-like structure for controlling the fit. See \code{\link[=PLNmixture_param]{PLNmixture_param()}} for details.}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
A matrix of posterior probabilities for each group (if type = "posterior"), a matrix of (average) position in the
latent space (if type = "position") or a vector of predicted groups (if type = "response").
}
\description{
Predict either posterior probabilities for each group or latent positions based on new samples
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLNmixture(Abundance ~ 1 + offset(log(Offset)),
           data = trichoptera, control = PLNmixture_param(smoothing = "none"))  \%>\% getBestModel()
predict(myPLN, trichoptera, "posterior")
predict(myPLN, trichoptera, "position")
predict(myPLN, trichoptera, "response")
}
