#' @title Convert gene symbol to Entrez_Gene_ID
#' @description The function `get_Entrez_ID` is used to convert gene symbol to Entrez_Gene_ID
#' @param mut_status A binary matrix that contains the mutation state of genes in each sample and its row name is the gene symbol. Noted the matrix can be generated by the function `get_mut_status`.
#' @param gene_symbol_Entrez A data table containing gene symbol and the corresponding gene Entrez ID.
#' @param Entrez_ID Logical,tell whether there are Entrez IDs corresponding to gene symbol in the gene_symbol_Entrez.
#' @return A binary matrix that contains the mutation state of genes in each sample and its row name is Entrez_Gene_ID.
#' @importFrom clusterProfiler bitr
#' @importFrom org.Hs.eg.db org.Hs.eg.db
#' @export
#' @examples
#' #load the data.
#' data(mut_status,gene_symbol_Entrez)
#' #perform function `get_Entrez_ID`.
#' mut_status<-get_Entrez_ID(mut_status,gene_symbol_Entrez,Entrez_ID=TRUE)


get_Entrez_ID<-function(mut_status,gene_symbol_Entrez,Entrez_ID=TRUE){
  if(Entrez_ID){
    rownames(mut_status)<-gsub(pattern = "-",replacement = ".",rownames(mut_status))
    gene_symbol_Entrez$Hugo_Symbol<-gsub(pattern = "-",replacement = ".",gene_symbol_Entrez$Hugo_Symbol)
    newdata<-matrix(data=0,nrow=dim(mut_status)[1],ncol=1)
    mut_status<-cbind(mut_status,newdata)
    loc<-match(rownames(mut_status),gene_symbol_Entrez$Hugo_Symbol)
    mut_status[,dim(mut_status)[2]]<-gene_symbol_Entrez[loc,2]
    mut_status<-mut_status[-which(mut_status[,dim(mut_status)[2]]%in%c(".",NA)),]
    mut_status<-mut_status[match(unique(mut_status[,dim(mut_status)[2]]),mut_status[,dim(mut_status)[2]]),]
    rownames(mut_status)<-mut_status[,dim(mut_status)[2]]
    mut_status<-mut_status[,-dim(mut_status)[2]]
  }else{
    newdata<-matrix(data=0,nrow=dim(mut_status)[1],ncol=1)
    mut_status<-cbind(mut_status,newdata)
    data1<- bitr(gene_symbol_Entrez$Hugo_Symbol, fromType = "SYMBOL",toType = c( "ENTREZID"),OrgDb = org.Hs.eg.db)
    mut_status[,dim(mut_status)[2]]<-data1[match(rownames(mut_status),data1$SYMBOL),2]
    mut_status<-mut_status[-which(mut_status[,dim(mut_status)[2]]%in%c(".",NA)),]
    mut_status<-mut_status[match(unique(mut_status[,dim(mut_status)[2]]),mut_status[,dim(mut_status)[2]]),]
    rownames(mut_status)<-mut_status[,dim(mut_status)[2]]
    mut_status<-mut_status[,-dim(mut_status)[2]]
  }
  return(mut_status)
}

