% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mut_status.R
\name{get_mut_status}
\alias{get_mut_status}
\title{Converts MAF file into mutation matrix}
\usage{
get_mut_status(maf_data, nonsynonymous = TRUE)
}
\arguments{
\item{maf_data}{The patients' somatic mutation data, which in MAF format.}

\item{nonsynonymous}{Logical, tell if extract the non-silent somatic mutations (nonsense mutation, missense mutation, frame-shif indels, splice site, nonstop mutation, translation start site, inframe indels).}
}
\value{
A binary mutations matrix, in which 1 represents that a particular gene has mutated in a particular sample, and 0 represents that gene has no mutation in a particular sample .
}
\description{
The function `get_mut_status` uses to convert MAF file into mutation matrix.
}
\examples{
#load the data
data(maf_data)
#perform the function `get_mut_status`.
mutmatrix.example<-get_mut_status(maf_data,nonsynonymous = TRUE)
}
