% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chackoTest.R
\name{chackoTest}
\alias{chackoTest}
\alias{chackoTest.default}
\alias{chackoTest.formula}
\title{Testing against Ordered Alternatives (Chacko's Test)}
\usage{
chackoTest(x, ...)

\method{chackoTest}{default}(x, g, ...)

\method{chackoTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Chacko's test for testing against ordered alternatives.
}
\details{
The null hypothesis, H\eqn{_0: \theta_1 = \theta_2 = \ldots = \theta_k}
is tested against a simple order hypothesis,
H\eqn{_\mathrm{A}: \theta_1 \le \theta_2 \le \ldots \le
\theta_k,~\theta_1 < \theta_k}.

The p-values are estimated from the chi-square distribution.
}
\section{Source}{

The source code for the application of the pool adjacent violators
theorem to calculate the isotonic means
was taken from the file \code{"pava.f"}, which is included in the
package \pkg{Iso}:

 Rolf Turner (2015). Iso: Functions to Perform Isotonic Regression. R
 package version 0.0-17. \url{https://CRAN.R-project.org/package=Iso}.

The file \code{"pava.f"} is a Ratfor modification of Algorithm AS 206.1:

Bril, G., Dykstra, R., Pillers, C., Robertson, T. (1984)
Statistical Algorithms: Algorithm AS 206: Isotonic
Regression in Two Independent Variables, \emph{Appl. Statist.}
\bold{34}, 352--357.

 The Algorith AS 206 is available from StatLib
\url{http://lib.stat.cmu.edu/apstat/}. The Royal Statistical Society
holds the copyright to these routines,
but has given its permission for their distribution provided that
no fee is charged.
}

\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")

## Chacko's test
chackoTest(x, g)

## Cuzick's test
cuzickTest(x, g)

## Johnson-Mehrotra test
johnsonTest(x, g)

## Jonckheere-Terpstra test
jonckheereTest(x, g)

## Le's test
leTest(x, g)

## Spearman type test
spearmanTest(x, g)

## Murakami's BWS trend test
bwsTrendTest(x, g)

}
\references{
Chacko, V. J. (1963) Testing homogeneity against ordered alternatives,
\emph{Ann. Math. Statist.} \bold{34}, 945--956.
}
\seealso{
\code{\link{kruskalTest}} and \code{\link{shirleyWilliamsTest}}
of the package \pkg{PMCMRplus},
\code{\link[stats]{kruskal.test}} of the library \pkg{stats}.
}
\concept{trendtest}
\keyword{htest}
\keyword{nonparametric}
