% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hartleyTest.R
\name{hartleyTest}
\alias{hartleyTest}
\alias{hartleyTest.default}
\alias{hartleyTest.formula}
\title{Hartley's Maximum F-Ratio Test of Homogeneity of
Variances}
\usage{
hartleyTest(x, ...)

\method{hartleyTest}{default}(x, g, ...)

\method{hartleyTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Hartley's maximum F-ratio test of the null that
 variances in each of the groups (samples) are the same.
}
\details{
If \code{x} is a list, its elements are taken as the samples
to be compared for homogeneity of variances.  In this
case, the elements must all be numeric data vectors,
\code{g} is ignored, and one can simply use
\code{hartleyTest(x)} to perform the test.  If the samples are not
yet contained in a list, use \code{hartleyTest(list(x, ...))}.

Otherwise, \code{x} must be a numeric data vector, and \code{g} must
be a vector or factor object of the same length as \code{x} giving the
group for the corresponding elements of \code{x}.

Hartley's parametric test requires normality and
a nearly balanced design. The p-value of the test
is calculated with the function \code{\link[SuppDists]{pmaxFratio}}
of the package \pkg{SuppDists}.
}
\examples{
hartleyTest(count ~ spray, data = InsectSprays)

}
\references{
Hartley, H.O. (1950) The maximum F-ratio
as a short cut test for heterogeneity of variance,
\emph{Biometrika} \bold{37}, 308--312.
}
\seealso{
\code{\link{bartlett.test}}, \code{\link[SuppDists]{pmaxFratio}}
}
\concept{parametric}
\keyword{htest}
