% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flignerWolfeTest.R
\name{flignerWolfeTest}
\alias{flignerWolfeTest}
\alias{flignerWolfeTest.default}
\alias{flignerWolfeTest.formula}
\title{Testing Several Treatments With One Control}
\usage{
flignerWolfeTest(x, ...)

\method{flignerWolfeTest}{default}(
  x,
  g,
  alternative = c("greater", "less"),
  dist = c("Wilcoxon", "Normal"),
  ...
)

\method{flignerWolfeTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  dist = c("Wilcoxon", "Normal"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"greater"}.}

\item{dist}{the test distribution. Defaults to \code{"Wilcoxon"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Fligner-Wolfe non-parametric test for
simultaneous testing of several locations (treatment groups)
against the location of the control group.
}
\details{
Let there be \eqn{k}-treatment groups and one control group, then
the null hypothesis, H\eqn{_0: \theta_i - \theta_c = 0 ~ (1 \le i \le k)}
is tested against the alternative (greater),
H\eqn{_\mathrm{A}: \theta_i - \theta_c > 0 ~ (1 \le i \le k)},
with at least one inequality being strict.

If \code{dist = Wilcoxon}, then the p-values are estimated from the  \code{\link[stats]{Wilcoxon}}
distribution, else the \code{\link[stats]{Normal}} distribution is used. The latter can be used,
if ties are present.
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")

## Chacko's test
chackoTest(x, g)

## Cuzick's test
cuzickTest(x, g)

## Johnson-Mehrotra test
johnsonTest(x, g)

## Jonckheere-Terpstra test
jonckheereTest(x, g)

## Le's test
leTest(x, g)

## Spearman type test
spearmanTest(x, g)

## Murakami's BWS trend test
bwsTrendTest(x, g)

## Fligner-Wolfe test
flignerWolfeTest(x, g)

}
\references{
Fligner, M.A., Wolfe, D.A. (1982)
 Distribution-free tests for comparing several
 treatments with a control. \emph{Stat Neerl} \bold{36},
 119--127.
}
\seealso{
\code{\link{kruskalTest}} and \code{\link{shirleyWilliamsTest}}
of the package \pkg{PMCMRplus},
\code{\link[stats]{kruskal.test}} of the library \pkg{stats}.
}
\concept{trendtest}
\concept{wilcoxonranks}
\keyword{htest}
\keyword{nonparametric}
