% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.williams.test.R
\name{power.williams.test}
\alias{power.williams.test}
\title{Power calculations for
minimum detectable difference of the Williams' test}
\usage{
power.williams.test(n = NULL, k, delta, sd = 1, power = NULL, ...)
}
\arguments{
\item{n}{number of observations (per group).}

\item{k}{number of treatment groups.}

\item{delta}{clinically meaningful minimal difference
(between a treatment group and control).}

\item{sd}{common standard deviation.}

\item{power}{power of test (1 minus Type II error probability).}

\item{\ldots}{further arguments, currently ignored.}
}
\value{
Object of class \sQuote{\code{power.htest}}, a list of the arguments
(including the
computed one) augmented with method and note elements.
}
\description{
Compute the power of a Williams' test,
or determine parameters to obtain a target power.
}
\details{
Exactly one of the parameters \code{n} or \code{power}
must be passed as \code{NULL}, and that
parameter is determined from the others.

The function has implemented the following Eq. in order to
estimate power (Chow et  al. 2008):

\deqn{
 1 - \beta = 1 - \Phi \left(T_{K \alpha v} -
 |\Delta| / \sigma \sqrt{2/n}\right)
}{%
 1 - beta = 1 - Phi( TKalpha - [|Delta| / sigma * sqrt(2/n)])
}

with \eqn{|\Delta|}{|Delta|} the clinically meaningful minimal difference,
\eqn{T_{K \alpha v}}{TKalpha} the critical Williams' t-statistic
for \eqn{\alpha = 0.05}{alpha = 0.05}, \eqn{v = \infty} degree of freedom
and \eqn{\Phi}{Phi} the probability function of the standard normal function.

The required sample size (balanced design) is estimated numerically
(see \code{\link[stats]{optimise}}). The optimal sample size
is searched within the interval of
\eqn{3 \leq n \leq 120}{3 <= n <= 120} in order to minimise
the squared difference between nominal power and estimated power.
}
\note{
The current function calculates power for \code{sig.level = 0.05}
significance level (Type I error probability) only (one-sided test).
}
\examples{
## Chow et al. 2008, p. 288 depicts 53 (rounded),
## better use ceiling for rounding
power.williams.test(power = 0.8, k = 3, delta = 11, sd = 22)
power.williams.test(n = 54, k = 3, delta = 11, sd = 22)

## PASS manual example:
## up-rounded n values are:
## 116, 52, 29, 14, 8 and 5
## according to PASS manual, p. 595-5
D <- c(10, 15, 20, 30, 40, 50)
y <- sapply(D, function(delta) {
 power.williams.test(power = 0.9, k = 4, delta = delta, sd = 25)$n
 })
ceiling(y)

\dontrun{
 ## compare with power.t.test
 ## and bonferroni correction
 power.t.test(power = 0.9, delta = 50, sd = 25,
 sig.level = 0.05 / 4, alternative = "one.sided")
}

}
\references{
Chow, S.-C., Shao, J., Wan, H., 2008,
\emph{Sample Size Calculations in Clinical Research}, 2nd ed,
Chapman & Hall/CRC: Boca Raton, FL.
}
\seealso{
\code{\link[stats]{optimise}} \code{\link{williamsTest}}
}
