% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Huberplot.R
\name{Huber.plot}
\alias{Huber.plot}
\title{Huber plot}
\usage{
Huber.plot(origdata2D,origclass,PPmethod="LDA",weight=TRUE,r=1,
           lambda=0.5,opt.proj=TRUE,UserDefFtn=NULL,...)
}
\arguments{
\item{origdata2D}{2-dimensional numerical data for Huber plot}

\item{origclass}{class information vector of data}

\item{PPmethod}{method for projection pursuit;
"LDA", "PDA", "Lr", "GINI", "ENTROPY", and "UserDef"}

\item{weight}{weight flag in LDA, PDA and Lr index}

\item{r}{r in Lr index}

\item{lambda}{lambda in PDA index}

\item{opt.proj}{flag to show the best projection in the plot}

\item{UserDefFtn}{User defined index function when PPmethod="UserDef"}

\item{...}{arguments to be passed to methods}
}
\description{
Huber plot for 2D data
}
\details{
Draw Huber plot for 2-dimensional data with various PP indices and
the histogram of the projected data onto the optimal projection to
explore the behavior of the projection prsuit indices
}
\examples{
data(iris)
Huber.plot(iris[,1:2],iris[,5],PPmethod="LDA")
}
\references{
Lee, EK., Cook, D., Klinke, S., and Lumley, T.(2005)
Projection Pursuit for Exploratory Supervised Classification,
Journal of Computational and Graphical Statistics, 14(4):831-846.
}
\keyword{projection}
\keyword{pursuit}

