% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subpick.R
\name{subpick}
\alias{subpick}
\title{projection pursuit \code{submodular} pick algorithm \code{PP SP-LIME}}
\usage{
subpick(data_long, final.leaf, obsnum = 5)
}
\arguments{
\item{data_long}{\code{ppshapr_prep} class object.}

\item{final.leaf}{location of final leaf}

\item{obsnum}{The number of budgets (instance to be selected). Default value is 1.}
}
\value{
Observation names and their original values as data
}
\description{
Pick several data containing various information for each final node for \code{PPTreereg}
\code{submodular} Pick (\code{SP-LIME}) was developed (Ribeiro et al., 2016) to selects
representative data with important information to determine the
reliability of model based on the \code{LIME} algorithm.
In order to extract data for each final node in the \code{PPTreereg} model,
 \code{PP SP-LIME} was proposed based on \code{SP-LIME}.
}
\examples{
data("dataXY")
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
shap_long=ppshapr_prep(Model,final.rule =3,method="simple")
subpick(shap_long,final.leaf = 1, obsnum = 5)


}
\references{
Ribeiro, Marco Tulio, Sameer Singh, and Carlos Guestrin.
"" Why should i trust you?" Explaining the predictions of any classifier." Proceedings of the 22nd ACM SIGKDD international conference on knowledge discovery and data mining. 2016.
\doi{10.1145/2939672.2939778}
\url{https://github.com/marcotcr/lime/blob/master/lime/submodular_pick.py}
}
\keyword{submodular}
