% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consunsus.R
\name{consunsus_sequence}
\alias{consunsus_sequence}
\title{consunsus_sequence}
\usage{
consunsus_sequence(pssm_name)
}
\arguments{
\item{pssm_name}{is the name of PSSM Matrix file}
}
\value{
consunsus sequence wich extracted from PSSM
}
\description{
This feature vector is constructed from PSSM Matrix as:
\eqn{\alpha(i)=argmax(P_{i,j})} where i varies between 1 and L and j between 1 and 20, L indicates protein length
and "arg" represents the argument of the maximum the ith base of the consensus sequence (CS) is then set to be the
\eqn{\alpha(i)}th amino acid in the amino acid alphabet and a consensus sequence is constructed.
}
\examples{
w<-consunsus_sequence(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Y. Liang, S. Liu, S. J. C. Zhang, and m. m. i. medicine, "Prediction of protein structural
classes for low-similarity sequences based on consensus sequence and segmented PSSM," vol. 2015, 2015.
}
