% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSContrast.R
\name{PSContrast}
\alias{PSContrast}
\title{Contrast of potential outcome for principal stratification analysis}
\usage{
PSContrast(
  outcome,
  S = NULL,
  Z = NULL,
  T = NULL,
  type = c("all", "sequential", "cycle")
)
}
\arguments{
\item{outcome}{an object of class \code{PSoutcome} or \code{PSContrast}}

\item{S}{a vector denoting which strata to take contrasts. Default is \code{NULL} indicating
no contrasts are taken. Set to `TRUE` to take contrasts between all strata.}

\item{Z}{a vector denoting which treatment arms to take contrasts. Default is \code{NULL} indicating
no contrasts are taken. Set to `TRUE` to take contrasts between all treatment arms.}

\item{T}{a vector denoting which time points to take contrasts. Default is \code{NULL} indicating
no contrasts are taken. Set to `TRUE` to take contrasts between all time points. This is used
only when `object` is obtained under survival outcome.}

\item{type}{Either \code{"all"} (default), \code{"sequential"} or \code{"cycle"}.
If \code{"all"}, every pairwise contrasts are taken.
If \code{"sequential"}, contrasts are taken over every consecutive pairs.
If \code{"cycle"}, contrasts are taken over every consecutive pairs and also between the
first and the last levels.}
}
\value{
An S3 object of class \code{PSContrast} and \code{PSOutcome}, containing
\item{outcome_array}{A num_strata * num_treatment * num_iter array of contrast if the outcome type is non-survival
or a num_strata * num_treatment * num_time_points * num_iter array of contrast if the outcome type is survival.}
\item{is.survival}{A boolean value, whether the outcome type is survival.}
\item{time_points}{The time points at which the outcome is evaluated, if the outcome type is survival.}
The S3 method \code{summary} and \code{plot} can be applied to the returned object.
}
\description{
Create an object that represents contrast of potential outcomes by treatment arms,
strata or time points.
}
