% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fiveparamanalysis.R
\name{fiveparamanalysis}
\alias{fiveparamanalysis}
\title{Five Parameter Isotherm Analysis}
\usage{
fiveparamanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the non linear regression and the parameters for the five parameter non-linear isotherm analysis
}
\description{
A five-parameter empirical model that is capable of simulating the model variations that applies over a wide range of equilibrium data. Its increased parameters provides a more accurate non linear regression, better than two, three or four parameters. (Subramanyam and Ashutosh, 2009)
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
fiveparamanalysis(Ce, Qe)
}
\references{
Fritz, W., & Schluender, E.U. (1974). Simultaneous adsorption equilibria of organic solutes in dilute aqueous solutions on activated carbon. Chemical Engineering Science, 29(5), 1279-1282. <doi: 10.1016/0009-2509(74)80128-4>

@references Subramanyam, B., & Das, A. (2009). Study of the adsorption of phenol by two soils based on kinetic and isotherm modeling analyses. Desalination, 249(3), 914-921. <doi:10.1016/j.desal.2009.05.020>
}
\author{
Jeff Ryan S. Magalong

Joshua Dela Cruz

Chester C. Deocaris
}
