% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_createMonitorObject.R
\name{wrcc_createMonitorObject}
\alias{wrcc_createMonitorObject}
\title{Obtain WRCC Data and Create ws_monitor Object}
\usage{
wrcc_createMonitorObject(startdate = 20020101,
  enddate = strftime(lubridate::now(), "\%Y\%m\%d", tz = "UTC"),
  unitID = NULL, clusterDiameter = 1000,
  baseUrl = "https://wrcc.dri.edu/cgi-bin/wea_list2.pl", saveFile = NULL)
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{unitID}{station identifier (will be upcased)}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see \code{addClustering})}

\item{baseUrl}{base URL for data queries}

\item{saveFile}{optional filename where raw CSV will be written}
}
\value{
A \emph{ws_monitor} object with WRCC data.
}
\description{
Obtains monitor data from an WRCC webservice and converts
it into a quality controlled, metadata enhanced \emph{ws_monitor} object
ready for use with all \code{monitor_~} functions.

Steps involved include:

\enumerate{
 \item{download CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
 \item{reshape data into deployment-by-property \code{meta} and and time-by-deployment \code{data} dataframes}
}
}
\note{
The downloaded CSV may be saved to a local file by providing an argument to the \code{saveFile} parameter.
}
\examples{
\dontrun{
sm13 <- wrcc_createMonitorObject(20150301, 20150831, unitID='sm13')
monitorLeaflet(sm13)
}
}
\seealso{
\code{\link{wrcc_downloadData}}

\code{\link{wrcc_parseData}}

\code{\link{wrcc_qualityControl}}

\code{\link{addClustering}}

\code{\link{wrcc_createMetaDataframe}}

\code{\link{wrcc_createDataDataframe}}
}
\keyword{WRCC}
