% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_toTidy.R
\name{monitor_toTidy}
\alias{monitor_toTidy}
\title{Convert `ws_monitor` data to a tidy format}
\usage{
monitor_toTidy(data = NULL)
}
\arguments{
\item{data}{Data to potentially convert.}
}
\value{
'Tidy' formatted `ws_monitor` data.
}
\description{
Changes write-optomized `ws_monitor` formatted data into a read-optomized
'tidy' format that is useful for 'tidyverse' functions. If the given data is
already in a tidy format, it is returned as is.
}
\examples{
ws_monitor <- monitor_subset(
  Northwest_Megafires,
  monitorIDs = c('530470009_01', '530470010_01')
)

ws_monTidy <- monitor_toTidy(ws_monitor)

\dontrun{
ws_monTidy2 <- monitor_toTidy(ws_monTidy)
}

}
