% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_createDataDataframes.R
\name{airnow_createDataDataframes}
\alias{airnow_createDataDataframes}
\title{Return Reshaped, Dataframes of AirNow Data}
\usage{
airnow_createDataDataframes(parameters = NULL, startdate = "",
  hours = 24)
}
\arguments{
\item{parameters}{vector of names of desired pollutants or NULL for all pollutants}

\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{hours}{desired number of hours of data to assemble}
}
\value{
List of dataframes where each dataframe contains all data for a unique parameter (e.g: "PM2.5", "NOX").
}
\description{
This function uses the \link{airnow_downloadParseData} function 
to download monthly dataframes of AirNow data and restructures that data into a format that is compatible
with the PWFSLSmoke package \emph{ws_monitor} data model.

AirNow data parameters include at least the following list:
\enumerate{
\item{BARPR}
\item{BC}
\item{CO}
\item{NO}
\item{NO2}
\item{NO2Y}
\item{NO2X}
\item{NOX}
\item{NOOY}
\item{OC}
\item{OZONE}
\item{PM10}
\item{PM2.5}
\item{PRECIP}
\item{RHUM}
\item{SO2}
\item{SRAD}
\item{TEMP}
\item{UV-AETH}
\item{WD}
\item{WS}
}

Setting \code{parameters=NULL} will generate a separate dataframe for each of the above parameters.
}
\note{
As of 2016-12-27, it appears that hourly data are available only for 2016 and
not for earlier years.
}
\examples{
\dontrun{
airnow_data <- airnow_createDataDataframes("PM2.5", 20160701)
}
}
\seealso{
\link{airnow_downloadParseData}

\link{airnow_qualityControl}
}
\keyword{AirNow}
