% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_identifyMonitorType.R
\name{airsis_identifyMonitorType}
\alias{airsis_identifyMonitorType}
\title{Identify AIRSIS monitor type}
\usage{
airsis_identifyMonitorType(df)
}
\arguments{
\item{df}{dataframe or raw character string containing AIRSIS data}
}
\value{
List including \code{monitorType}, \code{rawNames}, \code{columnNames} and \code{columnTypes}.
}
\description{
Examine the column names of the incoming dataframe (or first line
of raw text) to identify different types of monitor data provided by AIRSIS.

The return is a list includes everything needed to identify and parse the raw
data using \code{readr::read_csv()}:

\itemize{
\item{\code{monitorType}}{ -- identification string}
\item{\code{rawNames}}{ -- column names from the data (including special characters)}
\item{\code{columnNames}}{ -- assigned column names (special characters repaced with '.')}
\item{\code{columnTypes}}{ -- column type string for use with \code{readr::read_csv()}}
}

The \code{monitorType} will be one of:
\itemize{
\item{"\code{BAM1020}"}{ -- BAM1020 (e.g. USFS #49 in 2010)}
\item{"\code{EBAM}"}{ -- EBAM (e.g. USFS #1026 in 2010)}
\item{"\code{ESAM}"}{ -- E-Sampler (e.g. USFS #1002 in 2010)}
\item{"\code{UNKOWN}"}{ -- ???}
}
}
\examples{
\dontrun{
fileString <- airsis_downloadData( 20150701, 20151231, provider='USFS', unitID='1026')
monitorTypeList <- airsis_identifyMonitorType(fileString)
}
}
\references{
\href{http://usfs.airsis.com}{Interagency Real Time Smoke Monitoring}
}
\keyword{AIRSIS}
