// Generated by rstantools.  Do not edit by hand.

/*
    pandemicLP is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pandemicLP is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pandemicLP.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_pandemicModels_singleWave_poisson_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_pandemicModels_singleWave_poisson");
    reader.add_event(77, 75, "end", "model_pandemicModels_singleWave_poisson");
    return reader;
}
#include <stan_meta_header.hpp>
class model_pandemicModels_singleWave_poisson
  : public stan::model::model_base_crtp<model_pandemicModels_singleWave_poisson> {
private:
        int n;
        std::vector<int> y;
        double pop;
        double p;
        double a_alpha;
        double a_beta;
        double mu_delta;
        double sigma2_delta;
        double c_alpha;
        double c_beta;
        double alpha_alpha;
        double alpha_beta;
        double d_1_alpha;
        double d_1_beta;
        double d_2_alpha;
        double d_2_beta;
        double d_3_alpha;
        double d_3_beta;
        double mu_b_1;
        double sigma2_b_1;
        double phi_alpha;
        double phi_beta;
        double f_alpha;
        double f_beta;
public:
    model_pandemicModels_singleWave_poisson(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_pandemicModels_singleWave_poisson(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_pandemicModels_singleWave_poisson_namespace::model_pandemicModels_singleWave_poisson";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 1);
            current_statement_begin__ = 11;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(n));
            y = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
            }
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "pop", "double", context__.to_vec());
            pop = double(0);
            vals_r__ = context__.vals_r("pop");
            pos__ = 0;
            pop = vals_r__[pos__++];
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "p", "double", context__.to_vec());
            p = double(0);
            vals_r__ = context__.vals_r("p");
            pos__ = 0;
            p = vals_r__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            check_less_or_equal(function__, "p", p, 1);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "a_alpha", "double", context__.to_vec());
            a_alpha = double(0);
            vals_r__ = context__.vals_r("a_alpha");
            pos__ = 0;
            a_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "a_alpha", a_alpha, 0);
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "a_beta", "double", context__.to_vec());
            a_beta = double(0);
            vals_r__ = context__.vals_r("a_beta");
            pos__ = 0;
            a_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "a_beta", a_beta, 0);
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "mu_delta", "double", context__.to_vec());
            mu_delta = double(0);
            vals_r__ = context__.vals_r("mu_delta");
            pos__ = 0;
            mu_delta = vals_r__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "sigma2_delta", "double", context__.to_vec());
            sigma2_delta = double(0);
            vals_r__ = context__.vals_r("sigma2_delta");
            pos__ = 0;
            sigma2_delta = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma2_delta", sigma2_delta, 0);
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "c_alpha", "double", context__.to_vec());
            c_alpha = double(0);
            vals_r__ = context__.vals_r("c_alpha");
            pos__ = 0;
            c_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "c_alpha", c_alpha, 0);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "c_beta", "double", context__.to_vec());
            c_beta = double(0);
            vals_r__ = context__.vals_r("c_beta");
            pos__ = 0;
            c_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "c_beta", c_beta, 0);
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "alpha_alpha", "double", context__.to_vec());
            alpha_alpha = double(0);
            vals_r__ = context__.vals_r("alpha_alpha");
            pos__ = 0;
            alpha_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_alpha", alpha_alpha, 0);
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "alpha_beta", "double", context__.to_vec());
            alpha_beta = double(0);
            vals_r__ = context__.vals_r("alpha_beta");
            pos__ = 0;
            alpha_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_beta", alpha_beta, 0);
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "d_1_alpha", "double", context__.to_vec());
            d_1_alpha = double(0);
            vals_r__ = context__.vals_r("d_1_alpha");
            pos__ = 0;
            d_1_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_1_alpha", d_1_alpha, 0);
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "d_1_beta", "double", context__.to_vec());
            d_1_beta = double(0);
            vals_r__ = context__.vals_r("d_1_beta");
            pos__ = 0;
            d_1_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_1_beta", d_1_beta, 0);
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "d_2_alpha", "double", context__.to_vec());
            d_2_alpha = double(0);
            vals_r__ = context__.vals_r("d_2_alpha");
            pos__ = 0;
            d_2_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_2_alpha", d_2_alpha, 0);
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "d_2_beta", "double", context__.to_vec());
            d_2_beta = double(0);
            vals_r__ = context__.vals_r("d_2_beta");
            pos__ = 0;
            d_2_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_2_beta", d_2_beta, 0);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "d_3_alpha", "double", context__.to_vec());
            d_3_alpha = double(0);
            vals_r__ = context__.vals_r("d_3_alpha");
            pos__ = 0;
            d_3_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_3_alpha", d_3_alpha, 0);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "d_3_beta", "double", context__.to_vec());
            d_3_beta = double(0);
            vals_r__ = context__.vals_r("d_3_beta");
            pos__ = 0;
            d_3_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_3_beta", d_3_beta, 0);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "mu_b_1", "double", context__.to_vec());
            mu_b_1 = double(0);
            vals_r__ = context__.vals_r("mu_b_1");
            pos__ = 0;
            mu_b_1 = vals_r__[pos__++];
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "sigma2_b_1", "double", context__.to_vec());
            sigma2_b_1 = double(0);
            vals_r__ = context__.vals_r("sigma2_b_1");
            pos__ = 0;
            sigma2_b_1 = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma2_b_1", sigma2_b_1, 0);
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "phi_alpha", "double", context__.to_vec());
            phi_alpha = double(0);
            vals_r__ = context__.vals_r("phi_alpha");
            pos__ = 0;
            phi_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "phi_alpha", phi_alpha, 0);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "phi_beta", "double", context__.to_vec());
            phi_beta = double(0);
            vals_r__ = context__.vals_r("phi_beta");
            pos__ = 0;
            phi_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "phi_beta", phi_beta, 0);
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "f_alpha", "double", context__.to_vec());
            f_alpha = double(0);
            vals_r__ = context__.vals_r("f_alpha");
            pos__ = 0;
            f_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "f_alpha", f_alpha, 0);
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "f_beta", "double", context__.to_vec());
            f_beta = double(0);
            vals_r__ = context__.vals_r("f_beta");
            pos__ = 0;
            f_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "f_beta", f_beta, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 41;
            num_params_r__ += 1;
            current_statement_begin__ = 42;
            num_params_r__ += 1;
            current_statement_begin__ = 43;
            num_params_r__ += 1;
            current_statement_begin__ = 44;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_pandemicModels_singleWave_poisson() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 41;
        if (!(context__.contains_r("f")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable f missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("f");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "f", "double", context__.to_vec());
        double f(0);
        f = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(1, f);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable f: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 42;
        if (!(context__.contains_r("b1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "b1", "double", context__.to_vec());
        double b1(0);
        b1 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(-(30), b1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 43;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "a", "double", context__.to_vec());
        double a(0);
        a = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, ((p * pop) * stan::math::exp((f * b1))), a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 44;
        if (!(context__.contains_r("c")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "c", "double", context__.to_vec());
        double c(0);
        c = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, c);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 41;
            local_scalar_t__ f;
            (void) f;  // dummy to suppress unused var warning
            if (jacobian__)
                f = in__.scalar_lb_constrain(1, lp__);
            else
                f = in__.scalar_lb_constrain(1);
            current_statement_begin__ = 42;
            local_scalar_t__ b1;
            (void) b1;  // dummy to suppress unused var warning
            if (jacobian__)
                b1 = in__.scalar_lb_constrain(-(30), lp__);
            else
                b1 = in__.scalar_lb_constrain(-(30));
            current_statement_begin__ = 43;
            local_scalar_t__ a;
            (void) a;  // dummy to suppress unused var warning
            if (jacobian__)
                a = in__.scalar_lub_constrain(0, ((p * pop) * stan::math::exp((f * b1))), lp__);
            else
                a = in__.scalar_lub_constrain(0, ((p * pop) * stan::math::exp((f * b1))));
            current_statement_begin__ = 44;
            local_scalar_t__ c;
            (void) c;  // dummy to suppress unused var warning
            if (jacobian__)
                c = in__.scalar_lb_constrain(0, lp__);
            else
                c = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 50;
            local_scalar_t__ b;
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 51;
            validate_non_negative_index("mu", "n", n);
            std::vector<local_scalar_t__> mu(n, local_scalar_t__(0));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 53;
            stan::math::assign(b, stan::math::exp(b1));
            current_statement_begin__ = 55;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 56;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::exp(((((stan::math::log(f) + stan::math::log(a)) + stan::math::log(c)) - (c * t)) - ((f + 1) * stan::math::log((b + stan::math::exp((-(c) * t))))))), 
                            "assigning variable mu");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 50;
            if (stan::math::is_uninitialized(b)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "b", b, 0);
            current_statement_begin__ = 51;
            size_t mu_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(mu[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t mu_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mu[i_0__]", mu[i_0__], 0);
                check_less_or_equal(function__, "mu[i_0__]", mu[i_0__], pop);
            }
            // model body
            current_statement_begin__ = 65;
            lp_accum__.add(poisson_log<propto__>(y, mu));
            current_statement_begin__ = 69;
            lp_accum__.add(gamma_log<propto__>(a, a_alpha, a_beta));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(b1, mu_b_1, sigma2_b_1));
            current_statement_begin__ = 71;
            lp_accum__.add(gamma_log<propto__>(c, c_alpha, c_beta));
            current_statement_begin__ = 72;
            lp_accum__.add(gamma_log<propto__>(f, f_alpha, f_beta));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("f");
        names__.push_back("b1");
        names__.push_back("a");
        names__.push_back("c");
        names__.push_back("b");
        names__.push_back("mu");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_pandemicModels_singleWave_poisson_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double f = in__.scalar_lb_constrain(1);
        vars__.push_back(f);
        double b1 = in__.scalar_lb_constrain(-(30));
        vars__.push_back(b1);
        double a = in__.scalar_lub_constrain(0, ((p * pop) * stan::math::exp((f * b1))));
        vars__.push_back(a);
        double c = in__.scalar_lb_constrain(0);
        vars__.push_back(c);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 50;
            double b;
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 51;
            validate_non_negative_index("mu", "n", n);
            std::vector<double> mu(n, double(0));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 53;
            stan::math::assign(b, stan::math::exp(b1));
            current_statement_begin__ = 55;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 56;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::exp(((((stan::math::log(f) + stan::math::log(a)) + stan::math::log(c)) - (c * t)) - ((f + 1) * stan::math::log((b + stan::math::exp((-(c) * t))))))), 
                            "assigning variable mu");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 50;
            check_greater_or_equal(function__, "b", b, 0);
            current_statement_begin__ = 51;
            size_t mu_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mu[i_0__]", mu[i_0__], 0);
                check_less_or_equal(function__, "mu[i_0__]", mu[i_0__], pop);
            }
            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(b);
                size_t mu_k_0_max__ = n;
                for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                    vars__.push_back(mu[k_0__]);
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_pandemicModels_singleWave_poisson";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "f";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b";
            param_names__.push_back(param_name_stream__.str());
            size_t mu_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "f";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b";
            param_names__.push_back(param_name_stream__.str());
            size_t mu_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_pandemicModels_singleWave_poisson_namespace::model_pandemicModels_singleWave_poisson stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
