% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_set_obj.R
\name{matched_set}
\alias{matched_set}
\title{matched_set}
\usage{
matched_set(matchedsets, id, t, L, t.var, id.var, treatment.var)
}
\arguments{
\item{matchedsets}{a list of treated units and matched control units. Each element in the list should be a vector of control unit ids.}

\item{id}{A vector containing the ids of treated units}

\item{t}{A vector containing the times of treatment for treated units.}

\item{L}{integer specifying the length of the lag window used in matching}

\item{t.var}{string specifying the time variable}

\item{id.var}{string specifying the unit id variable}

\item{treatment.var}{string specifying the treatment variable.

The constructor function returns a \code{matched.set} object. 
\code{matched.set} objects are a modified lists. Each element in the list is a vector of ids 
corresponding to the control unit ids in a matched set. 
Additionally, these vectors might have additional attributes -- "weights". These correspond to the 
weights assigned to each control unit, 
as determined by the specified refinement method.
Each element in the list also has a name, which corresponds to the unit id of the treated unit and time of treatment, 
concatenated together and separated by a period. \code{matched.set} objects also have a number of 
methods defined: \code{summary}, \code{plot}, and \code{`[`}. \code{matched.set} objects can be modified manually
as long as these conventions (and conventions about other attributes) are maintained. It is important to note that \code{matched.set} objects 
are distinct from \code{PanelMatch} objects. \code{matched.set} objects are often contained within \code{PanelMatch} objects.}
}
\value{
\code{matched.set} objects have additional attributes. These reflect the specified parameters when using the \code{PanelMatch} function:
\item{lag}{an integer value indicating the length of treatment history to be used for matching. Treated and control units are matched based on whether or not they have exactly matching treatment histories in the lag window.}
\item{t.var}{time variable name, represented as a character/string}
\item{id.var}{unit id variable name, represented as a character/string}
\item{treatment.var}{treatment variable name, represented as a character/string}
\item{class}{class of the object: should always be "matched.set"}
\item{refinement.method}{method used to refine and/or weight the control units in each set.}
\item{covs.formula}{One sided formula indicating which variables should be used for matching and refinement}
\item{match.missing}{Logical variable indicating whether or not units should be matched on the patterns of missingness in their treatment histories}
\item{max.match.size}{Maximum size of the matched sets after refinement. This argument only affects results when using a matching method}
}
\description{
\code{matched_set} is a constructor for the \code{matched.set} class.
}
\details{
Users should never need to use this function by itself. See below for more about \code{matched.set} objects.
}
\author{
Adam Rauh <adamrauh@mit.edu>, In Song Kim <insong@mit.edu>, Erik Wang
<haixiao@Princeton.edu>, and Kosuke Imai <imai@harvard.edu>
}
