% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{pcSelect_parallel}
\alias{pcSelect_parallel}
\title{Estimate subgraph around a response variable using pcSelect_parallel.}
\usage{
pcSelect_parallel(y, dm, method = c("parallel"), mem.efficient = FALSE,
  num_workers, alpha, corMethod = "standard", verbose = FALSE,
  directed = FALSE)
}
\arguments{
\item{y}{The target (response) variable.}

\item{dm}{Data matrix with rows are samples and columns are variables.}

\item{method}{Character string specifying method; the default, "parallel" provides an parallelised method to implement all the conditional independence tests.}

\item{mem.efficient}{If TRUE, uses less amount of memory at any time point while running the algorithm}

\item{num_workers}{The numbers of cores CPU to run the algorithm}

\item{alpha}{Significance level of individual partial correlation tests.}

\item{corMethod}{"standard" or "Qn" for standard or robust correlation estimation}

\item{verbose}{Logical or in \{0,1,2\};

       FALSE, 0: No output,

       TRUE, 1: Little output,

       2: Detailed output.

       Note that such output makes the function very much slower.}

\item{directed}{Logical; should the output graph be directed?}
}
\value{
G    A logical vector indicating which column of dm is associated with y.

zMin   The minimal z-values when testing partial correlations between y and each column of dm. The larger the number, the more consistent is the edge with the data.
}
\description{
This is the parallelised version of the pcSelect (stable) function in the pcalg package. Assume that we have a fixed target variable, the algorithm will test the
dependency between each variable and the target variable conditioning on combinations of other variables.
}
\examples{
##########################################
## Using pcSelect_parallel without mem.efficeient
##########################################
library(pcalg)
library(parallel)
p <- 10
set.seed(101)
myDAG <- randomDAG(p, prob = 0.2)
n <- 1000
d.mat <- rmvDAG(n, myDAG, errDist = "normal")
pcSelect_parallel(d.mat[,10],d.mat[,-10], alpha=0.05,num_workers=2)

##########################################
## Using pcSelelct_parallel with mem.efficeient
##########################################
library(pcalg)
library(parallel)
p <- 10
set.seed(101)
myDAG <- randomDAG(p, prob = 0.2)
n <- 1000
d.mat <- rmvDAG(n, myDAG, errDist = "normal")
pcSelect_parallel(d.mat[,10],d.mat[,-10], alpha=0.05,mem.efficient=TRUE,num_workers=2)
}

