% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{PiecewisePareto_Layer_Mean}
\alias{PiecewisePareto_Layer_Mean}
\title{Layer Mean of the Piecewise Pareto Distribution}
\usage{
PiecewisePareto_Layer_Mean(
  Cover,
  AttachmentPoint,
  t,
  alpha,
  truncation = NULL,
  truncation_type = "lp"
)
}
\arguments{
\item{Cover}{Numeric. Cover of the reinsurance layer.}

\item{AttachmentPoint}{Numeric. Attachment point of the reinsurance layer.}

\item{t}{Numeric vector. Thresholds of the piecewise Pareto distribution.}

\item{alpha}{Numeric vector. \code{alpha[i]} is the Pareto alpha in excess of \code{t[i]}.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}

\item{truncation_type}{Character. If \code{truncation_type = "wd"} then the whole distribution is truncated. If \code{truncation_type = "lp"} then a truncated Pareto is used for the last piece.}
}
\value{
The expected loss of the (truncated) piecewise Pareto distribution with parameter vectors \code{t} and \code{alpha} in the layer
        \code{Cover} xs \code{AttachmentPoint}
}
\description{
Calculates the expected loss of a piecewise Pareto distribution in a reinsurance layer
}
\examples{
t <- c(1000, 2000, 3000)
alpha <- c(1, 1.5, 2)
PiecewisePareto_Layer_Mean(4000, 1000, t, alpha)
PiecewisePareto_Layer_Mean(4000, 1000, t, alpha, truncation = 5000)
PiecewisePareto_Layer_Mean(4000, 1000, t, alpha, truncation = 5000, truncation_type = "lp")
PiecewisePareto_Layer_Mean(4000, 1000, t, alpha, truncation = 5000, truncation_type = "wd")

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
