% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMisc.R
\docType{package}
\name{PathwaySpace-package}
\alias{PathwaySpace}
\alias{PathwaySpace-package}
\title{PathwaySpace: Spatial Projection of Network Signals along Geodesic Paths}
\description{
For a given graph containing vertices, edges, and a signal associated with
the vertices, the PathwaySpace package performs a convolution operation,
which involves a weighted combination of neighboring vertices and their
associated signals. The package then uses a decay function to propagate
these signals, creating geodesic paths on a 2D-image space.
}
\details{
\tabular{ll}{
Package: \tab PathwaySpace\cr
Type: \tab Software\cr
License: \tab Artistic-2.0\cr
Maintainer: \tab Mauro Castro \email{mauro.a.castro@gmail.com}\cr
}
}
\section{Index}{

\tabular{ll}{
\link{PathwaySpace-class}: 
\tab An S4 class for signal propagation on pathway spaces.\cr
\link{buildPathwaySpace}: 
\tab Constructor of PathwaySpace-class objects.\cr
\link{circularProjection}: 
\tab Creating 2D-landscape images from graph objects.\cr
\link{polarProjection}: 
\tab Creating 2D-landscape images from graph objects.\cr
\link{silhouetteMapping}: 
\tab Mapping graph silhouettes on PathwaySpace images.\cr
\link{summitMapping}: 
\tab Mapping summits on a 2D-landscape image.\cr
\link{getPathwaySpace}: 
\tab Accessory method for fetching slots from a PathwaySpace object.\cr
\link{plotPathwaySpace}: 
\tab Plotting 2D-landscape images for the PathwaySpace package.\cr
}
Further information is available in the vignettes by typing
\code{vignette('PathwaySpace')}. Documented topics are also available in
HTML by typing \code{help.start()} and selecting the PathwaySpace package
from the menu.
}

\references{
The Cancer Genome Atlas Analysis Network (2023). PathwaySpace: Spatial propagation 
of network signals along geodesic paths. R package version 0.99.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/sysbiolab/PathwaySpace}
  \item Report bugs at \url{https://github.com/sysbiolab/PathwaySpace/issues}
}

}
\author{
The Cancer Genome Atlas Analysis Network
}
\keyword{internal}
