% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addSex}
\alias{addSex}
\title{Compute the sex of the individuals}
\usage{
addSex(x, cdm = attr(x, "cdm_reference"), sexName = "sex", tablePrefix = NULL)
}
\arguments{
\item{x}{Table with individuals in the cdm}

\item{cdm}{Object that contains a cdm reference. Use CDMConnector to obtain a
cdm reference.}

\item{sexName}{name of the new column to be added}

\item{tablePrefix}{The stem for the permanent tables that will
be created. If NULL, temporary tables will be used throughout.}
}
\value{
table x with the added column with sex information
}
\description{
Compute the sex of the individuals
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- mockPatientProfiles()
cdm$cohort1 \%>\% addSex(cdm)
}

}
