% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkewnessKurtosisRatio.R
\name{SkewnessKurtosisRatio}
\alias{SkewnessKurtosisRatio}
\alias{Skewness-KurtosisRatio}
\title{Skewness-Kurtosis ratio of the return distribution}
\usage{
SkewnessKurtosisRatio(R, ...)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{\dots}{any other passthru parameters}
}
\description{
Skewness-Kurtosis ratio is the division of Skewness by Kurtosis.
}
\details{
It is used in conjunction with the Sharpe ratio to rank portfolios.
The higher the rate the better.

\deqn{ SkewnessKurtosisRatio(R , MAR) = \frac{S}{K}}{SkewnessKurtosisRatio(R, MAR) = S/K}

where \eqn{S} is the skewness and \eqn{K} is the Kurtosis
}
\examples{

data(portfolio_bacon)
print(SkewnessKurtosisRatio(portfolio_bacon[,1])) #expected -0.034

data(managers)
print(SkewnessKurtosisRatio(managers['1996']))
print(SkewnessKurtosisRatio(managers['1996',1]))

}
\references{
Carl Bacon, \emph{Practical portfolio performance measurement 
and attribution}, second edition 2008 p.100
}
\author{
Matthieu Lestel
}
