% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\title{Skewness}
\usage{
skewness(x, na.rm = FALSE, method = c("moment", "fisher", "sample"),
  ...)
}
\arguments{
\item{x}{a numeric vector or object.}

\item{na.rm}{a logical. Should missing values be removed?}

\item{method}{a character string which specifies the method of computation.
These are either \code{"moment"} or \code{"fisher"} The \code{"moment"}
method is based on the definitions of skewnessfor distributions; these forms
should be used when resampling (bootstrap or jackknife). The \code{"fisher"}
method correspond to the usual "unbiased" definition of sample variance,
although in the case of skewness exact unbiasedness is not possible. The 
\code{"sample"} method gives the sample skewness of the distribution.}

\item{\dots}{arguments to be passed.}
}
\description{
compute skewness of a univariate distribution.
}
\details{
This function was ported from the RMetrics package fUtilities to eliminate a
dependency on fUtiltiies being loaded every time.  The function is identical
except for the addition of \code{\link{checkData} and column support.}

\deqn{Skewness(moment) = \frac{1}{n}*\sum^{n}_{i=1}(\frac{r_i - \overline{r}}{\sigma_P})^3}{Skewness(moment) = sum((x-mean(x))^3/var(x)^(3/2))/length(x)}
\deqn{Skewness(sample) =  \frac{n}{(n-1)*(n-2)}*\sum^{n}_{i=1}(\frac{r_i - \overline{r}}{\sigma_{S_P}})^3 }{skewness(sample) = sum(((x-mean(x))/var(x))^3)*n/((n-1)*(n-2))}
\deqn{Skewness(fisher) = \frac{\frac{\sqrt{n*(n-1)}}{n-2}*\sum^{n}_{i=1}\frac{x^3}{n}}{\sum^{n}_{i=1}(\frac{x^2}{n})^{3/2}}}{Skewness(fisher)((sqrt(n*(n-1))/(n-2))*(sum(x^3)/n))/((sum(x^2)/n)^(3/2))}

where \eqn{n} is the number of return, \eqn{\overline{r}} is the mean of the return
distribution, \eqn{\sigma_P} is its standard deviation and \eqn{\sigma_{S_P}} is its
sample standard deviation
}
\examples{

## mean -
## var -
   # Mean, Variance:
   r = rnorm(100)
   mean(r)
   var(r)

## skewness -
   skewness(r)
data(managers)
skewness(managers)

}
\references{
Carl Bacon, \emph{Practical portfolio performance measurement 
and attribution}, second edition 2008 p.83-84
}
\seealso{
\code{\link{kurtosis}}
}
\author{
Diethelm Wuertz, Matthieu Lestel
}
