% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_load_indicator.R
\name{compute_pesticide_load_indicator_single}
\alias{compute_pesticide_load_indicator_single}
\title{Compute Pesticide Load Indicator for a single application using the Pesticide Properties database}
\usage{
compute_pesticide_load_indicator_single(
  folder,
  product,
  year,
  formula,
  substances,
  cas_numbers,
  concentrations,
  ...
)
}
\arguments{
\item{folder}{Folder with exported xlsx files from PPDB containing information on active ingredient properties.}

\item{product}{Product name of the applied pesticide.}

\item{year}{Application year.}

\item{formula}{Load formulation factor for applied product.}

\item{substances}{List or vector of active ingredient names of the applied pesticide.}

\item{cas_numbers}{List or vector of CAS numbers of the respective active ingredients.}

\item{concentrations}{List or vector of product concentrations of the respective active ingredients.}

\item{...}{overrides for default Load factors.}
}
\value{
Dataframe with pesticide indicators for a single pesticide application
indicated by the user.
Computes Pesticide Load Indicator (L) and its subindicators:
The Human Health Load (HL), Ecotoxicity Load (TL) and Fate Load (FL).
}
\description{
Compute Pesticide Load Indicator for a single application using the Pesticide Properties database
}
\examples{
\dontrun{
# Indicate the folder containing the "General","Fate", "Human" and "Ecotox" tables of the PPPDB.
# Excel files (under the exact same name, e.g. Human.xlsx) are required.
# Attention, a licensed access to the PPPDB (Lewis et al., 2016) is required.
# Note that the "Fate" table should include a column indicating the "SCI.GROW" values
folder <- "path"

# Compute the Pesticide Load indicator and its subindicators for a single product.
# Allows to optionally alter the predefined Load.Values.
compute_pesticide_load_indicator_single(
  folder=folder,
  product="Agora",
  year=2009,
  formula=1.5,
  substances=c("Cyproconazol", "Trifloxystrobin"),
  cas_numbers=c("94361-06-5", "141517-21-7"),
  concentrations = c(0.08,0.1875)
)
}
}
