% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_IS_fit.R
\name{LP_IS_fit}
\alias{LP_IS_fit}
\title{Fit a Lincoln-Petersen Model with incomplete stratification}
\usage{
LP_IS_fit(
  data,
  p_model,
  theta_model = ~-1 + ..time,
  lambda_model = ~-1 + ..cat,
  logit_p_offset = 0,
  logit_theta_offset = 0,
  logit_lambda_offset = 0,
  cat.unknown = "U",
  p_beta.start = NULL,
  trace = FALSE,
  control.optim = list(trace = 0, maxit = 1000)
)
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting. At the moment, you are not allowed to use these covariates
to used in the modeling process, but see the published code for more details.}

\item{p_model}{Model for the captured probabilities. This can reference
other variables in the data frame, plus a special reserved term \code{..time} to indicate
a time dependence in the capture probabilities. For example, \code{p_model=~1} would indicate
that the capture probabilities are equal across the sampling events;
\code{p_model=~..time} would indicate that the capture probabilities vary by sampling events;
\code{p_model=~sex*..time} would indicate that the capture probabilities vary across
all combination of sampling events (\code{..time}) and a stratification variable (\code{sex}). The \code{sex} variable
also needs to be in the data frame.

For some models (e.g., tag loss models), the \code{..time} variable cannot be used because
the conditional models (on being captured at the second event) end up having
only have one capture probability (e.g., only for event 1) because of the conditioning process.}

\item{theta_model}{Model for theta (sampling fraction). Usually, this is set to be different
for the two sampling occasions, but you can constrain this to have equal sampling fractions at both occasions.}

\item{lambda_model}{Model for lambda category proportions. Usually this is set to different for the categories
but you can constrain this with a null matrix and the \code{logit_lamba_offset} parameter}

\item{logit_p_offset}{Used to fix capture probabilities at known values (seldom useful). Logit(p)=p_design \%*\% beta_p + logit_p_offset.}

\item{logit_theta_offset}{Used to fix sampling fractions at known values (seldom useful).
logit(theta) = theta_design \%*\% beta_theta + logit_theta_offset}

\item{logit_lambda_offset}{Used to fix the sex ratio as a known value (e.g. .50) using
logit(lambda) = lambda_design \%*\% beta_lambda + logit_lambda_offset.
Set the design matrix to a matrix with all zeros. Notice that because the lambda proportions must sum to 1,
only specify an offset matrix that is number of categories -1.}

\item{cat.unknown}{Value of character used to indicate the unknown stratum in the capture histories. Currently, this
is fixed to "U" regardless of what is specified.}

\item{p_beta.start}{Initial values for call to optimization routine for the beta parameters (on the logit scale).
The values will be replicated to match
the number of initial beta parameters needed. Some care is needed here!}

\item{trace}{If trace flag is set in call when estimating functions}

\item{control.optim}{Control values passed to optim() optimizer.}
}
\value{
An list object of class \emph{LP_IS_fit} with abundance estimates and other information with the following elements
\itemize{
\item \strong{summary} A data frame with the model for the capture probabilities, the sampling fractions at each capture occasion, and the category proportions;
the conditional log-likelihood; the number of parameters; the number of parameters, and method used to fit the model
\item \strong{data} A data frame with the raw data used in the fit
\item \strong{fit} Results of the fit including the estimates, SE, vcov, etc.
\item \strong{fit.call} Arguments used in the fit
\item \strong{datetime} Date and time the fit was done
}
}
\description{
In some LP studies, stratification is only done on a random sample of unmarked
fish, e.g., only a sample of fish is sexed. Is is known as incomplete stratification.
This is a wrapper to the published code for the case of stratification by a
discrete covariate. At the moment, no other covariates are allowed, but see
the published code.
}
\details{
The frequency variable (\code{freq} in the \code{data} argument) is the number of animals with the corresponding capture history.

Capture histories (\code{cap_hist} in the \code{data} argument) are character values of length 2.
The strata values are single character values with "U" typically representing a fish not measured
for the stratification variable. For example, consider the case where only a sample of unmarked fish
are examined for sex (M or F). Possible capture histories are:

\itemize{
\item \strong{M0}  Animals tagged and sexed as male but never seen again.
\item \strong{MM}  Animals tagged and sexed as male and recaptured and tag present at event 2.
\item \strong{0M}  Animals captured at event 2 that appears to be untagged and was sexed as male.
\item \strong{F0}  Animals tagged and sexed as female but never seen again.
\item \strong{FF}  Animals tagged and sexed as female and recaptured and tag present at event 2.
\item \strong{0F}  Animals captured at event 2 that appears to be untagged and was sexed as female.
\item \strong{U0}  Animals tagged and not sexed but never seen again.
\item \strong{UU}  Animals tagged and not sexed and recaptured and tag present at event 2.
\item \strong{0U}  Animals captured at event 2 that appears to be untagged and was not sexed.
}

Capture histories such as \strong{UF} or \strong{UM} are not allowed since only UNTAGGED animals
are examined and sexed. Similarly, capture histories such as \strong{FM} or \strong{MF} are not allowed.
}
\examples{

data(data_wae_is_short)
fit <- Petersen::LP_IS_fit(data=data_wae_is_short, p_model=~..time)
fit$summary
est <- LP_IS_est(fit, N_hat=~1)
est$summary

}
\references{
Premarathna, W.A.L., Schwarz, C.J., Jones, T.S. (2018)
Partial stratification in two-sample capture–recapture experiments.
Environmetrics, 29:e2498. \doi{10.1002/env.2498}
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
