% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDPH_functions.R
\name{MDPH_functions}
\alias{MDPH_functions}
\alias{dMDPH}
\alias{qMDPH}
\alias{pMDPH}
\alias{rMDPH}
\alias{rFullMDPH}
\title{The Multivariate Discrete Phase-Type Distribution}
\usage{
dMDPH(x, obj)

qMDPH(p, obj)

pMDPH(q, obj)

rMDPH(n, obj)

rFullMDPH(obj)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{obj}{an object of class \code{mult_disc_phase_type}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be
the number required.}
}
\value{
\code{dMDPH} gives the density, \code{pMDPH} gives the
distribution function, \code{qMDPH} gives the quantile function,
and \code{rMDPH} generates random deviates. \code{rFullMDPH} returns
the full path of a random draw from the distribution.

Each row of the result of For \code{dMDPH}, \code{pMDPH}, \code{qMDPH}, and
\code{rMDPH} corresponds to each univariate reward transformation.
For \code{dMDPH}, \code{qMDPH} and \code{pMDPH}, the inputs \code{x},
\code{p} and \code{q} can be matrices where in row i the i_th reward
transformation and in col j the j_th value of \code{x}, \code{p} or \code{q}
tested.

The length of the result is determined by \code{n} for \code{rMDPH},
and is the maximum of the lengths of the numerical arguments for the other
functions.

The numerical arguments other than \code{n} are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation
for the multivariate discrete phase-type distribution.
}
\section{Functions}{
\itemize{
\item \code{dMDPH}: Density function for the multivariate discrete phase-type distribution.

\item \code{qMDPH}: Quantile function for the multivariate discrete phase-type distribution.

\item \code{pMDPH}: Distribution function for the multivariate discrete phase-type distribution.

\item \code{rMDPH}: Random number generator for the multivariate discrete phase-type distribution.

\item \code{rFullMDPH}: Simulation of the full path for the multivariate discrete phase-type distribution.
}}

\examples{

disc_phase_type <- matrix(c(0.4, 0, 0.2,
                            0.5, 0.3, 0.2,
                            0, 0.7, 0.2), ncol = 3)
R <- matrix(c(0, 1, 1,
              2, 1, 5,
              0, 1, 10,
              1, 2, 3), nrow = 3)
Y <- MDPH(disc_phase_type, reward_mat = R)

dMDPH(3:4, Y)
pMDPH(1.45, Y)
qMDPH(0.5, Y)
set.seed(0)
rMDPH(6, Y)
rFullMDPH(Y)

}
\seealso{
\link[stats]{Distributions} for other standard distributions.
}
