
<!-- README.md is generated from README.Rmd. Please edit that file.      -->
<!-- To locally generate README.md, run rmarkdown::render('README.Rmd'). -->

## PhotoGEA <a href="https://eloch216.github.io/PhotoGEA/"><img src="man/figures/logo.svg" align="left" style="height:138px"></a>

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/PhotoGEA)](https://cran.r-project.org/package=PhotoGEA)
[![](https://cranlogs.r-pkg.org/badges/grand-total/PhotoGEA)](https://cran.r-project.org/package=PhotoGEA)
[![R-CMD-check](https://github.com/eloch216/PhotoGEA/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/eloch216/PhotoGEA/actions/workflows/R-CMD-check.yaml)
[![codecov](https://codecov.io/gh/eloch216/PhotoGEA/graph/badge.svg)](https://app.codecov.io/gh/eloch216/PhotoGEA?branch=main)
<!-- badges: end -->

### Overview

**PhotoGEA** (short for **photo**synthetic **g**as **e**xchange
**a**nalysis) is an R package that provides a suite of tools for
loading, processing, and analyzing photosynthetic gas exchange data. See
[Lochocki, Salesse-Smith, & McGrath
(2025)](https://onlinelibrary.wiley.com/doi/10.1111/pce.15501) for more
information.

### Installation

`PhotoGEA` is available on
[CRAN](https://cran.r-project.org/package=PhotoGEA), so the easiest way
to install the latest release is to type the following from within an R
terminal:

``` r
install.packages('PhotoGEA')
```

See the [Frequently Asked
Questions](https://eloch216.github.io/PhotoGEA/articles/web_only/frequent_questions.html)
for alternative installation methods.

### Usage

The best way to learn about using `PhotoGEA` is to visit the [PhotoGEA
website](https://eloch216.github.io/PhotoGEA/index.html) and click the
[Get
started](https://eloch216.github.io/PhotoGEA/articles/PhotoGEA.html)
link in the top menu bar. The website includes documentation for all the
functions and data sets included in the package, as well as articles
that describe its general features and several important use cases.

### Example Scripts

The [PhotoGEA
Publications](https://eloch216.github.io/PhotoGEA/articles/web_only/publications.html)
page includes links to publicly-available analysis scripts that have
been used for peer-reviewed publications. These may be a useful source
of ideas.

Several example scripts are also provided in the `example_scripts`
directory of the [source code
repository](https://github.com/eloch216/PhotoGEA). To run one of these
scripts, set the working directory to a folder that contains a local
copy of the script and use the `source` command to execute the code in
the script. No guarantees are made that these scripts will run on your
machine or be compatible with your data, but they may also be a useful
source of ideas.

### License

The `PhotoGEA` R package, its documentation, and its associated example
scripts are licensed under the MIT license.
