\name{text.dt.madlib}
\alias{text.dt.madlib}

\title{
    Add labels onto the figure generated by plot.dt.madlib
}
\description{
  This is a function which adds labels to the plot generated by \code{\link{plot.dt.madlib}}. 
}

\usage{ 
    
    \method{text}{dt.madlib}(x, splits = TRUE, label, FUN = text, all = FALSE,
    pretty = NULL, digits = getOption("digits") - 3L, use.n = FALSE, fancy
    = FALSE, fwidth = 0.8, fheight = 0.8, bg = par("bg"), minlength = 1L, ...) 

}

\arguments{
  \item{x}{
    The fitted tree from the result of \code{\link{madlib.rpart}}
}
  \item{splits}{
    A boolean, if TRUE, labels the splits with the criterion for the split.
}
  \item{label}{
    This is currently ignored.
}
  \item{FUN}{
    The name of a labeling function, e.g. text
}
  \item{all}{
    A boolean, if TRUE, labels all the nodes, otherwise just the terminal nodes.
}
  \item{pretty}{
    An alternative to the \code{minlength} argument.
}
  \item{digits}{
    Number of significant digits to include in numeric labels.
}
  \item{use.n}{
    A boolean, if TRUE, adds to label (\#events level1/ \#events level2/etc. for classification 
    and n for regression)
}
  \item{fancy}{
    A boolean, if TRUE, represents internal nodes by ellipses and leaves by rectangles. 
}
  \item{fwidth}{
    Controls the width of the ellipses and rectangles if fancy=TRUE.
}
  \item{fheight}{
    Controls the height of the ellipses and rectangles if fancy=TRUE.
}
  \item{bg}{
    The color used to paint the background if fancy=TRUE.
}
  \item{minlength}{
    The length to use for factor labels.
}
  \item{\dots}{
    Other graphical parameters to be supplied as input to this function (see \code{\link{par}}).
}
}

\references{
[1] Documentation of decision tree in MADlib 1.6, \url{http://doc.madlib.net/latest/}
}

\author{
  Author: Predictive Analytics Team at Pivotal Inc.
  
  Maintainer: Frank McQuillan, Pivotal Inc. \email{fmcquillan@pivotal.io}
}

\seealso{
  
  \code{\link{madlib.rpart}} is the wrapper for MADlib's tree_train function for decision trees.
  \code{\link{plot.dt.madlib}}, \code{\link{print.dt.madlib}} are visualization functions 
  for a model fitted through madlib.rpart 
  
  \code{\link{predict.dt.madlib}} is a wrapper for MADlib's predict function for 
  decision trees.

  \code{\link{madlib.lm}}, \code{\link{madlib.glm}},
        \code{\link{madlib.summary}}, \code{\link{madlib.arima}}, \code{\link{madlib.elnet}}
            are all MADlib wrapper functions.
}

\examples{
\dontrun{
%% @test .port Database port number
%% @test .dbname Database name
## set up the database connection
## Assume that .port is port number and .dbname is the database name
cid <- db.connect(port = .port, dbname = .dbname, verbose = FALSE)

x <- as.db.data.frame(abalone, conn.id = cid, verbose = FALSE)

key(x) <- "id"
fit <- madlib.rpart(rings < 10 ~ length + diameter + height + whole + shell, 
       data=x, parms = list(split='gini'), control = list(cp=0.005))

plot(fit, uniform=TRUE)
text(fit, use.n=TRUE, all=TRUE)

db.disconnect(cid)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
