% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_per_clone.R
\name{VDJ_per_clone}
\alias{VDJ_per_clone}
\title{VDJ_per_clone}
\usage{
VDJ_per_clone(
  clonotype.list,
  VDJ.out.directory,
  contig.list,
  fasta.list,
  reference.list,
  filtered.contigs,
  annotations.json,
  JSON
)
}
\arguments{
\item{clonotype.list}{Output from either VDJ_analyze or VDJ_clonotype functions. This list should correspond to a single GEX.list object, in which each list element in clonotype.list is found in the GEX.object. Furthermore, the i'th entry in the directory supplied to GEX.list should correspond to the i'th element in the clonotype.list object.}

\item{VDJ.out.directory}{Character vector with each element containing the path to the output of cellranger vdj runs. This corresponds to the same object used for the VDJ_analyze function. Multiple repertoires to be integrated in a single transcriptome should be supplied as multiple elements of the character vector. This can be left blank if supplying the clonotypes and contig files directly as input. This pipeline assumes that the output file names have not been changed from the default 10x settings in the /outs/ folder. This is compatible with B and T cell repertoires (both separately and simultaneously).}

\item{contig.list}{List of dataframe based on the all_contigs.csv file from cellranger vdj output. If 10x sequencing was not used then this object should be formatted with the same columns as the 10x object.}

\item{fasta.list}{Contains the full-length sequence information in the same format as filtered_contig.fasta file from the output of cellranger.}

\item{reference.list}{Contains the reference sequence information in the same format as concat_ref.fasta file from the output of cellranger.}

\item{filtered.contigs}{Logical indicating if the filtered contigs file should be used. TRUE will read VDJ information from only the filtered output of cellranger. FALSE will read the all contigs file from cellranger. Default set to TRUE (filtered output)}

\item{annotations.json}{Optional input from loaded all_contig_annotations.json. Will be read in automatically if not provided}

\item{JSON}{Boolean. Defaults to FALSE. Whether to load all_contig_annotations.json}
}
\value{
Returns a list of dataframes containing
}
\description{
only Platypus v2 Analyzes and processes the repertoire sequencing data from cellranger vdj. This provides information on the single-cell level for each clone, as opposed to the output from VDJ_analyze.
}
\examples{
\dontrun{
VDJ_per_clone_out <- VDJ_per_clone(clonotype.list = output.from.VDJ_analyze
,VDJ.out.directory = "path/to/cellranger/outs/")
}
}
