% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maths.R
\name{recalculate_baseline}
\alias{recalculate_baseline}
\title{Recalculate Baseline}
\usage{
recalculate_baseline(
  ftir,
  sample_ids = NA,
  wavenumber_range = NA,
  method = "average",
  individually = TRUE
)
}
\arguments{
\item{ftir}{A data.frame of FTIR spectral data including spectra to be
baseline adjusted.

Un data.frame de données spectrales IRTF comprenant les spectres à ajuster
à la ligne de base.}

\item{sample_ids}{A vector of sample IDs to be adjusted. All sample IDs must
be present in the \code{ftir} data.frame. If adjusting all spectra, provide NA
or NULL. Unlisted \code{sample_id} from \code{ftir} will be left alone.

Un vecteur d'ID d'échantillons à ajuster Tous les ID d'échantillons doivent
être présents dans la base de données \code{ftir} data.frame. Si l'ajustement
concerne tous les spectres, fournir NA ou NULL. Les \code{sample_id} non listés
de \code{ftir} seront laissés seuls.}

\item{wavenumber_range}{If specifying a single point wavenumber; a single
numeric value. If specifying a wavenumber range, then a vector of two
numeric values.

Si l'on spécifie un nombre d'ondes ponctuel, une seule valeur numérique. Si
l'on spécifie un nombre d'ondes, alors un vecteur de deux valeurs
numériques.}

\item{method}{One of three values:
\itemize{
\item If adjusting by the value from a specific wavenumber, provide \code{"point"},
\item If adjusting by the average from a range, provide \code{"average"}.
\item If adjusting by the minimum (for absorbance) or maximum (for transmittance) from a range or spectra, provide \code{"minimum"} or \code{"maximum"}, the appropriate transformation will be performed based on spectra type.

Une des trois valeurs :
\item Si l'ajustement se fait par la valeur d'un nombre d'ondes spécifique, fournir \code{"point"},
\item Si l'ajustement se fait par la moyenne d'une gamme, fournir \code{"average"}.
\item Si l'ajustement se fait par le minimum (pour l'absorbance) ou le maximum (pour la transmittance) d'une gamme ou de spectres, indiquez \code{"minimum"} ou \code{"maximum"}, la transformation appropriée sera effectuée en fonction du type de spectre.
}}

\item{individually}{If adjusting all samples by the same amount, specify
\code{TRUE}, else specify \code{FALSE} for unique adjustments. When \code{TRUE}, the
smallest absolute individual sample adjustment to achieve baseline will be
applied to all named samples.

Si vous ajustez tous les échantillons de la même manière, spécifiez \code{TRUE},
sinon spécifiez \code{FALSE} pour des ajustements uniques. Si \code{TRUE}, le plus
petit ajustement absolu d'un échantillon individuel pour atteindre la ligne
de base sera appliqué à tous les échantillons nommés.}
}
\value{
A data.frame containing the adjusted FTIR spectra.

Un data.frame contenant les spectres IRTF ajustee.
}
\description{
It may be desired to shift the baseline signal (0 for absorbance
or 100 for transmittance) to aid in plotting the spectra. This can be done
for all samples or a subset, using the same shift for all adjusted samples
or calculated individually.

Recalculate or shift to baseline/max transmittance can be done following
one of a few methods:
\itemize{
\item To shift baseline based on the value at a given wavenumber:
\verb{recalculate_baseline(ftir, wavenumber_range = [numeric], method =   'point')}
\item To shift baseline based on the average value across a provided wavenumber range:
\verb{recalculate_baseline(ftir, wavenumber_range = c([numeric], [numeric]),   method = 'average')}
\item To shift baseline based on the value at the single lowest point of absorbance
(or highest point of transmittance) across the whole spectra
\code{recalculate_baseline(ftir, method = 'minimum')}
\item To shift baseline based on the value at the single lowest point of absorbance
(or highest point of transmittance) in a given range
\verb{recalculate_baseline(ftir, wavenumber_range = c([numeric], [numeric]),   method = 'minimum')}
}

To perform the exact same baseline adjustment on all samples, specify
\code{individually = FALSE}. To adjust with a unique determination for each
sample, specify \code{individualy = TRUE}.

Il peut être souhaitable de décaler le signal de la ligne de base (0 pour
l'absorbance ou 100 pour la transmittance) pour faciliter le tracé des
spectres. Cela peut être fait pour tous les échantillons ou un
sous-ensemble, en utilisant le même décalage pour tous les échantillons
ajustés ou calculés individuellement.

Le recalcul ou le décalage de la ligne de base/transmittance maximale peut
être effectué en suivant l'une des méthodes suivantes :
\itemize{
\item Pour décaler la ligne de base en fonction de la valeur à un nombre d'ondes donné :
\verb{recalculate_baseline(ftir, wavenumber_range = [numeric], method = 'point')}
\item Pour décaler la ligne de base en fonction de la valeur moyenne sur un nombre
d'ondes donné : #' \verb{recalculate_baseline(ftir) = [numerique], method = 'point') }recalculate_baseline(ftir, wavenumber_range = c(\link{numeric}, \link{numeric}),
method = 'average')`
\item Pour décaler la ligne de base en fonction de la valeur du point d'absorbance
le plus bas (ou du point de transmittance le plus élevé) sur l'ensemble des spectres.
\code{recalculate_baseline(ftir, method = 'minimum')}
\item Décaler la ligne de base en fonction de la valeur du point d'absorbance le
plus bas (ou du point de transmittance le plus élevé) dans une gamme donnée.
\verb{recalculate_baseline(ftir, wavenumber_range = c([numeric], [numeric]), method = 'minimum')}

Pour effectuer exactement le même ajustement de la ligne de base sur tous
les échantillons, spécifiez \code{individually = FALSE}. Pour ajuster avec une
détermination unique pour chaque échantillon, spécifiez \code{individualy = TRUE}.
}
}
\examples{
# Adjust the biodiesel spectra to minimum for each sample
recalculate_baseline(biodiesel, method = "minimum", individually = TRUE)
}
