% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maths.R
\name{average_spectra}
\alias{average_spectra}
\title{Average FTIR Spectra}
\usage{
average_spectra(ftir, sample_ids = NA, average_id = "averaged_spectra")
}
\arguments{
\item{ftir}{A data.frame of FTIR spectral data including spectra to be
converted.

Un data.frame de données spectrales IRTF comprenant les spectres à
convertir.}

\item{sample_ids}{A vector of sample IDs to be averaged together. All sample
IDs must be present in the \code{ftir} data.frame. If averaging all spectra,
provide \code{NA} or \code{NULL.}

Un vecteur d'identifiants d'échantillons dont la moyenne doit être
calculée.. Tous les identifiants des échantillons doivent être présents
dans le data.frame \code{ftir}. Si la moyenne est calculée pour tous les
spectres, indiquez \code{NA} ou \code{NULL.}}

\item{average_id}{The name to be used as \code{sample_id} for the averaged
spectra.

Le nom à utiliser en tant que \code{sample_id} pour les spectres moyennés.}
}
\value{
A data.frame containing the averaged FTIR spectra, with \code{sample_id}
corresponding to the provided \code{average_id}.

Un data.frame contenant les spectres IRTF moyennés, avec \code{sample_id}
correspondant à l'identifiant \code{average_id} fourni.
}
\description{
Calculates an average of two or more spectra.

Calcule la moyenne de deux spectres ou plus.
}
\examples{
# Calculate the average of biodiesel B5 spectra and the unknown spectra

average_spectra(biodiesel, c("biodiesel_5_0", "biodiesel_B5", "diesel_unknown"))
}
