% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulations.R
\name{rename_plot_sample_ids}
\alias{rename_plot_sample_ids}
\title{Rename Sample IDs in Plot}
\usage{
rename_plot_sample_ids(ftir_spectra_plot, sample_ids)
}
\arguments{
\item{ftir_spectra_plot}{A plot generated by \code{\link[=plot_ftir]{plot_ftir()}} or
\code{\link[=plot_ftir_stacked]{plot_ftir_stacked()}}.

Un tracé généré par \code{\link[=plot_ftir]{plot_ftir()}} ou \code{\link[=plot_ftir_stacked]{plot_ftir_stacked()}}.}

\item{sample_ids}{A named vector of format \code{"new name" = "old name"}. Must
include \emph{all} sample ID old names (a pair of \code{"old name" = "old name"} is
permissible and results in no renaming for that sample).

Un vecteur nommé du format \code{"nouveau nom" = "ancien nom"}. Doit inclure
\emph{tous} les anciens noms d'ID d'échantillon (une paire de \code{"ancien nom" = "ancien nom"} est autorisée et n'entraîne aucun changement de nom pour cet
échantillon).}
}
\value{
the FTIR plot as a ggplot2 object, with samples renamed in the
legend.

le tracé IRTF en tant qu'objet ggplot2, avec les échantillons renommés dans
la légende.
}
\description{
This function permits renaming Sample IDs as shown in the legend
of a plot. While typically having proper names assigned in the data is
preferred, this function allows for names to be modified after plot
creation.

Cette fonction permet de renommer les identifiants des échantillons dans la
légende d'un tracé. Bien qu'il soit préférable d'attribuer les noms
appropriés dans les données, cette fonction permet de modifier les noms
après la création du tracé.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  # Generate a plot
  p <- plot_ftir(sample_spectra)

  # Rename Samples in Legend:
  new_ids <- c(
    "Toluene" = "toluene", "C7 Alkanes" = "heptanes", "IPA" = "isopropanol",
    "White Paper" = "paper", "PS Film" = "polystyrene"
  )
  rename_plot_sample_ids(p, new_ids)
}
}
