% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruSDM_predict.R
\name{plot.bruSDM_predict}
\alias{plot.bruSDM_predict}
\title{Generic plot function for \code{predict_bru_sdm}.}
\usage{
\method{plot}{bruSDM_predict}(
  x,
  whattoplot = c("mean"),
  cols = NULL,
  layout = NULL,
  colourLow = NULL,
  colourHigh = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{A bruSDM_predict object.}

\item{whattoplot}{One of the following statistics to plot: "mean", "sd", "q0.025", "median","q0.975", "smin", "smax", "cv", "var"}

\item{cols}{Number of columns required for the plotting. Used by inlabru's multiplot function.}

\item{layout}{Layout of the plots. Used by inlabru's multiplot function.}

\item{colourLow}{Colour for the low values in the predictions (see ?scale_colour_gradient from \code{ggplot2}). Defaults to \code{NULL}. If non-\code{NULL}, \code{colourHigh} is required.}

\item{colourHigh}{Colour for the high values in the predictions (see ?scale_colour_gradient from \code{ggplot2}). Defaults to \code{NULL}. If non-\code{NULL}, \code{colourLow} is required.}

\item{plot}{Should the plots be printed, defaults to \code{TRUE}. If \code{FALSE} will  produce a list of ggplot objects.}

\item{...}{Argument not used}
}
\value{
A ggplot2 object.
}
\description{
Plot for predict_bru_sdm
}
\examples{
\dontrun{
 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- "+proj=longlat +ellps=WGS84"
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
  ##Run the model
  modelRun <- fitISDM(organizedData, options = list(control.inla = list(int.strategy = 'eb')))
   
  #Predict spatial field on linear scale
  predictions <- predict(modelRun, mesh = mesh, spatial = TRUE, fun = 'linear')
   
  #Make generic plot of predictions
  plot(predictions, colourHigh = 'red', colourLow = 'orange')
 
 }
}

}
