#' R wrapper for the Poloniex Public and Trading API.
#'
#' This package provides a user-friendly R wrapper on top of the
#' Poloniex (Cryptocurrency Trading) REST API. The JSON results of the API calls are translated into R
#' Datastructures and are subsequently returned to the user in an intuitive manner.
#'
#' The package provides the user with two separate classes:
#'  - PoloniexPublicAPI: Allows the user to call Poloniex Public API functions.
#'  - PoloniexTradingAPI: Allows the user to call Poloniex trading API functions.
#'
#' Examples:
#'  https://github.com/VermeirJellen/PoloniexR
#'  http://EssentialQuant.com/blog/PoloniexR
#'
#' @docType package
#' @name PoloniexR
#' @importFrom methods is new validObject
#' @import jsonlite
#' @import RApiDatetime
#' @import zoo
NULL
