/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session;

import java.util.HashMap;
import java.util.Map;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.MessageHandler;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.codec.Coder;
import org.openfast.error.ErrorCode;
import org.openfast.session.AbstractSessionControlProtocol;
import org.openfast.session.BasicClient;
import org.openfast.session.Connection;
import org.openfast.session.MessageListener;
import org.openfast.session.Session;
import org.openfast.session.SessionConstants;
import org.openfast.session.SessionListener;
import org.openfast.session.SessionMessageHandler;
import org.openfast.session.template.exchange.AbstractFieldInstructionConverter;
import org.openfast.session.template.exchange.ComposedDecimalConverter;
import org.openfast.session.template.exchange.ConversionContext;
import org.openfast.session.template.exchange.DynamicTemplateReferenceConverter;
import org.openfast.session.template.exchange.GroupConverter;
import org.openfast.session.template.exchange.ScalarConverter;
import org.openfast.session.template.exchange.SequenceConverter;
import org.openfast.session.template.exchange.StaticTemplateReferenceConverter;
import org.openfast.session.template.exchange.VariableLengthInstructionConverter;
import org.openfast.template.BasicTemplateRegistry;
import org.openfast.template.DynamicTemplateReference;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Scalar;
import org.openfast.template.Sequence;
import org.openfast.template.StaticTemplateReference;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;

public class SessionControlProtocol_1_1
extends AbstractSessionControlProtocol {
    public static final String NAMESPACE = "http://www.fixprotocol.org/ns/fast/scp/1.1";
    private static final QName RESET_PROPERTY = new QName("reset", "http://www.fixprotocol.org/ns/fast/scp/1.1");
    private static final Map messageHandlers = new HashMap();
    private final ConversionContext initialContext = SessionControlProtocol_1_1.createInitialContext();
    public static final int FAST_RESET_TEMPLATE_ID = 120;
    public static final int FAST_HELLO_TEMPLATE_ID = 16002;
    public static final int FAST_ALERT_TEMPLATE_ID = 16003;
    public static final int TEMPLATE_DECL_ID = 16010;
    public static final int TEMPLATE_DEF_ID = 16011;
    public static final int INT32_INSTR_ID = 16012;
    public static final int UINT32_INSTR_ID = 16013;
    public static final int INT64_INSTR_ID = 16014;
    public static final int UINT64_INSTR_ID = 16015;
    public static final int DECIMAL_INSTR_ID = 16016;
    public static final int COMP_DECIMAL_INSTR_ID = 16017;
    public static final int ASCII_INSTR_ID = 16018;
    public static final int UNICODE_INSTR_ID = 16019;
    public static final int BYTE_VECTOR_INSTR_ID = 16020;
    public static final int STAT_TEMP_REF_INSTR_ID = 16021;
    public static final int DYN_TEMP_REF_INSTR_ID = 16022;
    public static final int SEQUENCE_INSTR_ID = 16023;
    public static final int GROUP_INSTR_ID = 16024;
    public static final int CONSTANT_OP_ID = 16025;
    public static final int DEFAULT_OP_ID = 16026;
    public static final int COPY_OP_ID = 16027;
    public static final int INCREMENT_OP_ID = 16028;
    public static final int DELTA_OP_ID = 16029;
    public static final int TAIL_OP_ID = 16030;
    public static final int FOREIGN_INSTR_ID = 16031;
    public static final int ELEMENT_ID = 16032;
    public static final int TEXT_ID = 16033;
    public static final MessageTemplate FAST_ALERT_TEMPLATE = new MessageTemplate("Alert", new Field[]{new Scalar("Severity", Type.U32, Operator.NONE, ScalarValue.UNDEFINED, false), new Scalar("Code", Type.U32, Operator.NONE, ScalarValue.UNDEFINED, false), new Scalar("Value", Type.U32, Operator.NONE, ScalarValue.UNDEFINED, true), new Scalar("Description", Type.ASCII, Operator.NONE, ScalarValue.UNDEFINED, false)});
    public static final MessageTemplate FAST_HELLO_TEMPLATE = new MessageTemplate("Hello", new Field[]{new Scalar("SenderName", Type.ASCII, Operator.NONE, ScalarValue.UNDEFINED, false), new Scalar("VendorId", Type.ASCII, Operator.NONE, ScalarValue.UNDEFINED, true)});
    public static final Message RESET = new Message(FAST_RESET_TEMPLATE){
        private static final long serialVersionUID = 1L;

        public void setFieldValue(int fieldIndex, FieldValue value) {
            throw new IllegalStateException("Cannot set values on a fast reserved message.");
        }
    };
    private static final MessageHandler RESET_HANDLER;
    private static final SessionMessageHandler ALERT_HANDLER;
    private static final MessageTemplate ATTRIBUTE;
    private static final MessageTemplate ELEMENT;
    private static final MessageTemplate OTHER;
    private static final MessageTemplate TEMPLATE_NAME;
    private static final MessageTemplate NS_NAME;
    private static final MessageTemplate NS_NAME_WITH_AUX_ID;
    private static final MessageTemplate FIELD_BASE;
    private static final MessageTemplate PRIM_FIELD_BASE;
    private static final MessageTemplate LENGTH_PREAMBLE;
    private static final MessageTemplate PRIM_FIELD_BASE_WITH_LENGTH;
    public static final MessageTemplate INT32_INSTR;
    public static final MessageTemplate UINT32_INSTR;
    public static final MessageTemplate INT64_INSTR;
    public static final MessageTemplate UINT64_INSTR;
    public static final MessageTemplate DECIMAL_INSTR;
    public static final MessageTemplate UNICODE_INSTR;
    public static final MessageTemplate ASCII_INSTR;
    public static final MessageTemplate BYTE_VECTOR_INSTR;
    public static final MessageTemplate TYPE_REF;
    public static final MessageTemplate TEMPLATE_DECLARATION;
    public static final MessageTemplate TEMPLATE_DEFINITION;
    public static final MessageTemplate OP_BASE;
    public static final MessageTemplate CONSTANT_OP;
    public static final MessageTemplate DEFAULT_OP;
    public static final MessageTemplate COPY_OP;
    public static final MessageTemplate INCREMENT_OP;
    public static final MessageTemplate DELTA_OP;
    public static final MessageTemplate TAIL_OP;
    public static final MessageTemplate GROUP_INSTR;
    public static final MessageTemplate SEQUENCE_INSTR;
    public static final MessageTemplate STAT_TEMP_REF_INSTR;
    public static final MessageTemplate DYN_TEMP_REF_INSTR;
    public static final MessageTemplate FOREIGN_INSTR;
    public static final MessageTemplate TEXT;
    public static final MessageTemplate COMP_DECIMAL_INSTR;
    public static final Message DYN_TEMP_REF_MESSAGE;
    private static final TemplateRegistry TEMPLATE_REGISTRY;
    private static final Message CLOSE;

    static {
        FAST_RESET_TEMPLATE.setAttribute(RESET_PROPERTY, "yes");
        RESET_HANDLER = new MessageHandler(){

            public void handleMessage(Message readMessage, Context context, Coder coder) {
                if (readMessage.getTemplate().hasAttribute(RESET_PROPERTY)) {
                    coder.reset();
                }
            }
        };
        ALERT_HANDLER = new SessionMessageHandler(){

            public void handleMessage(Session session, Message message) {
                ErrorCode alertCode = ErrorCode.getAlertCode(message);
                if (alertCode.equals(SessionConstants.CLOSE)) {
                    session.close(alertCode);
                } else {
                    session.getErrorHandler().error(alertCode, message.getString(4));
                }
            }
        };
        ATTRIBUTE = new MessageTemplate(new QName("Attribute", NAMESPACE), new Field[]{SessionControlProtocol_1_1.dict("Ns", Type.UNICODE, true, "template"), SessionControlProtocol_1_1.unicode("Name"), SessionControlProtocol_1_1.unicode("Value")});
        ELEMENT = new MessageTemplate(new QName("Element", NAMESPACE), new Field[]{SessionControlProtocol_1_1.dict("Ns", Type.UNICODE, true, "template"), SessionControlProtocol_1_1.unicode("Name"), new Sequence(SessionControlProtocol_1_1.qualify("Attributes"), new Field[]{new StaticTemplateReference(ATTRIBUTE)}, false), new Sequence(SessionControlProtocol_1_1.qualify("Content"), new Field[]{DynamicTemplateReference.INSTANCE}, false)});
        OTHER = new MessageTemplate(new QName("Other", NAMESPACE), new Field[]{new Group(SessionControlProtocol_1_1.qualify("Other"), new Field[]{new Sequence(SessionControlProtocol_1_1.qualify("ForeignAttributes"), new Field[]{new StaticTemplateReference(ATTRIBUTE)}, true), new Sequence(SessionControlProtocol_1_1.qualify("ForeignElements"), new Field[]{new StaticTemplateReference(ELEMENT)}, true)}, true)});
        TEMPLATE_NAME = new MessageTemplate(new QName("TemplateName", NAMESPACE), new Field[]{SessionControlProtocol_1_1.dict("Ns", Type.UNICODE, false, "template"), new Scalar(SessionControlProtocol_1_1.qualify("Name"), Type.UNICODE, Operator.NONE, null, false)});
        NS_NAME = new MessageTemplate(new QName("NsName", NAMESPACE), new Field[]{new Scalar(SessionControlProtocol_1_1.qualify("Ns"), Type.UNICODE, Operator.COPY, null, false), new Scalar(SessionControlProtocol_1_1.qualify("Name"), Type.UNICODE, Operator.NONE, null, false)});
        NS_NAME_WITH_AUX_ID = new MessageTemplate(new QName("NsNameWithAuxId", NAMESPACE), new Field[]{new StaticTemplateReference(NS_NAME), new Scalar(SessionControlProtocol_1_1.qualify("AuxId"), Type.UNICODE, Operator.NONE, null, true)});
        FIELD_BASE = new MessageTemplate(new QName("PrimFieldBase", NAMESPACE), new Field[]{new StaticTemplateReference(NS_NAME_WITH_AUX_ID), new Scalar(SessionControlProtocol_1_1.qualify("Optional"), Type.U32, Operator.NONE, null, false), new StaticTemplateReference(OTHER)});
        PRIM_FIELD_BASE = new MessageTemplate(new QName("PrimFieldBase", NAMESPACE), new Field[]{new StaticTemplateReference(FIELD_BASE), new Group(SessionControlProtocol_1_1.qualify("Operator"), new Field[]{DynamicTemplateReference.INSTANCE}, true)});
        LENGTH_PREAMBLE = new MessageTemplate(new QName("LengthPreamble", NAMESPACE), new Field[]{new StaticTemplateReference(NS_NAME_WITH_AUX_ID), new StaticTemplateReference(OTHER)});
        PRIM_FIELD_BASE_WITH_LENGTH = new MessageTemplate(new QName("PrimFieldBaseWithLength", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Group(SessionControlProtocol_1_1.qualify("Length"), new Field[]{new StaticTemplateReference(LENGTH_PREAMBLE)}, true)});
        INT32_INSTR = new MessageTemplate(new QName("Int32Instr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.I32, Operator.NONE, null, true)});
        UINT32_INSTR = new MessageTemplate(new QName("UInt32Instr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.U32, Operator.NONE, null, true)});
        INT64_INSTR = new MessageTemplate(new QName("Int64Instr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.I64, Operator.NONE, null, true)});
        UINT64_INSTR = new MessageTemplate(new QName("UInt64Instr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.U64, Operator.NONE, null, true)});
        DECIMAL_INSTR = new MessageTemplate(new QName("DecimalInstr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.DECIMAL, Operator.NONE, null, true)});
        UNICODE_INSTR = new MessageTemplate(new QName("UnicodeInstr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE_WITH_LENGTH), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.UNICODE, Operator.NONE, null, true)});
        ASCII_INSTR = new MessageTemplate(new QName("AsciiInstr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.ASCII, Operator.NONE, null, true)});
        BYTE_VECTOR_INSTR = new MessageTemplate(new QName("ByteVectorInstr", NAMESPACE), new Field[]{new StaticTemplateReference(PRIM_FIELD_BASE_WITH_LENGTH), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.BYTE_VECTOR, Operator.NONE, null, true)});
        TYPE_REF = new MessageTemplate(new QName("TypeRef", NAMESPACE), new Field[]{new Group(SessionControlProtocol_1_1.qualify("TypeRef"), new Field[]{new StaticTemplateReference(NS_NAME), new StaticTemplateReference(OTHER)}, true)});
        TEMPLATE_DECLARATION = new MessageTemplate(new QName("TemplateDecl", NAMESPACE), new Field[]{new StaticTemplateReference(TEMPLATE_NAME), SessionControlProtocol_1_1.u32("TemplateId")});
        TEMPLATE_DEFINITION = new MessageTemplate(new QName("TemplateDef", NAMESPACE), new Field[]{new StaticTemplateReference(TEMPLATE_NAME), SessionControlProtocol_1_1.unicodeopt("AuxId"), SessionControlProtocol_1_1.u32opt("TemplateId"), new StaticTemplateReference(TYPE_REF), SessionControlProtocol_1_1.u32("Reset"), new StaticTemplateReference(OTHER), new Sequence(SessionControlProtocol_1_1.qualify("Instructions"), new Field[]{DynamicTemplateReference.INSTANCE}, false)});
        OP_BASE = new MessageTemplate(new QName("OpBase", NAMESPACE), new Field[]{SessionControlProtocol_1_1.unicodeopt("Dictionary"), new Group(SessionControlProtocol_1_1.qualify("Key"), new Field[]{new StaticTemplateReference(NS_NAME)}, true), new StaticTemplateReference(OTHER)});
        CONSTANT_OP = new MessageTemplate(new QName("ConstantOp", NAMESPACE), new Field[]{new StaticTemplateReference(OTHER)});
        DEFAULT_OP = new MessageTemplate(new QName("DefaultOp", NAMESPACE), new Field[]{new StaticTemplateReference(OTHER)});
        COPY_OP = new MessageTemplate(new QName("CopyOp", NAMESPACE), new Field[]{new StaticTemplateReference(OP_BASE)});
        INCREMENT_OP = new MessageTemplate(new QName("IncrementOp", NAMESPACE), new Field[]{new StaticTemplateReference(OP_BASE)});
        DELTA_OP = new MessageTemplate(new QName("DeltaOp", NAMESPACE), new Field[]{new StaticTemplateReference(OP_BASE)});
        TAIL_OP = new MessageTemplate(new QName("TailOp", NAMESPACE), new Field[]{new StaticTemplateReference(OP_BASE)});
        GROUP_INSTR = new MessageTemplate(new QName("GroupInstr", NAMESPACE), new Field[]{new StaticTemplateReference(FIELD_BASE), new StaticTemplateReference(TYPE_REF), new Sequence(SessionControlProtocol_1_1.qualify("Instructions"), new Field[]{DynamicTemplateReference.INSTANCE}, false)});
        SEQUENCE_INSTR = new MessageTemplate(new QName("SequenceInstr", NAMESPACE), new Field[]{new StaticTemplateReference(FIELD_BASE), new StaticTemplateReference(TYPE_REF), new Group(SessionControlProtocol_1_1.qualify("Length"), new Field[]{new Group(SessionControlProtocol_1_1.qualify("Name"), new Field[]{new StaticTemplateReference(NS_NAME_WITH_AUX_ID)}, true), new Group(SessionControlProtocol_1_1.qualify("Operator"), new Field[]{DynamicTemplateReference.INSTANCE}, true), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.U32, Operator.NONE, null, true), new StaticTemplateReference(OTHER)}, true), new Sequence(SessionControlProtocol_1_1.qualify("Instructions"), new Field[]{DynamicTemplateReference.INSTANCE}, false)});
        STAT_TEMP_REF_INSTR = new MessageTemplate(new QName("StaticTemplateRefInstr", NAMESPACE), new Field[]{new StaticTemplateReference(TEMPLATE_NAME), new StaticTemplateReference(OTHER)});
        DYN_TEMP_REF_INSTR = new MessageTemplate(new QName("DynamicTemplateRefInstr", NAMESPACE), new Field[]{new StaticTemplateReference(OTHER)});
        FOREIGN_INSTR = new MessageTemplate(SessionControlProtocol_1_1.qualify("ForeignInstr"), new Field[]{new StaticTemplateReference(ELEMENT)});
        TEXT = new MessageTemplate(SessionControlProtocol_1_1.qualify("Text"), new Field[]{new Scalar(SessionControlProtocol_1_1.qualify("Value"), Type.UNICODE, Operator.NONE, ScalarValue.UNDEFINED, false)});
        COMP_DECIMAL_INSTR = new MessageTemplate(SessionControlProtocol_1_1.qualify("CompositeDecimalInstr"), new Field[]{new StaticTemplateReference(FIELD_BASE), new Group(SessionControlProtocol_1_1.qualify("Exponent"), new Field[]{new Group(SessionControlProtocol_1_1.qualify("Operator"), new Field[]{DynamicTemplateReference.INSTANCE}, false), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.I32, Operator.NONE, ScalarValue.UNDEFINED, true), new StaticTemplateReference(OTHER)}, true), new Group(SessionControlProtocol_1_1.qualify("Mantissa"), new Field[]{new Group(SessionControlProtocol_1_1.qualify("Operator"), new Field[]{DynamicTemplateReference.INSTANCE}, false), new Scalar(SessionControlProtocol_1_1.qualify("InitialValue"), Type.I32, Operator.NONE, ScalarValue.UNDEFINED, true), new StaticTemplateReference(OTHER)}, true)});
        DYN_TEMP_REF_MESSAGE = new Message(DYN_TEMP_REF_INSTR);
        TEMPLATE_REGISTRY = new BasicTemplateRegistry();
        TEMPLATE_REGISTRY.register(16002, FAST_HELLO_TEMPLATE);
        TEMPLATE_REGISTRY.register(16003, FAST_ALERT_TEMPLATE);
        TEMPLATE_REGISTRY.register(120, FAST_RESET_TEMPLATE);
        TEMPLATE_REGISTRY.register(16010, TEMPLATE_DECLARATION);
        TEMPLATE_REGISTRY.register(16011, TEMPLATE_DEFINITION);
        TEMPLATE_REGISTRY.register(16012, INT32_INSTR);
        TEMPLATE_REGISTRY.register(16013, UINT32_INSTR);
        TEMPLATE_REGISTRY.register(16014, INT64_INSTR);
        TEMPLATE_REGISTRY.register(16015, UINT64_INSTR);
        TEMPLATE_REGISTRY.register(16016, DECIMAL_INSTR);
        TEMPLATE_REGISTRY.register(16017, COMP_DECIMAL_INSTR);
        TEMPLATE_REGISTRY.register(16018, ASCII_INSTR);
        TEMPLATE_REGISTRY.register(16019, UNICODE_INSTR);
        TEMPLATE_REGISTRY.register(16020, BYTE_VECTOR_INSTR);
        TEMPLATE_REGISTRY.register(16021, STAT_TEMP_REF_INSTR);
        TEMPLATE_REGISTRY.register(16022, DYN_TEMP_REF_INSTR);
        TEMPLATE_REGISTRY.register(16023, SEQUENCE_INSTR);
        TEMPLATE_REGISTRY.register(16024, GROUP_INSTR);
        TEMPLATE_REGISTRY.register(16025, CONSTANT_OP);
        TEMPLATE_REGISTRY.register(16026, DEFAULT_OP);
        TEMPLATE_REGISTRY.register(16027, COPY_OP);
        TEMPLATE_REGISTRY.register(16028, INCREMENT_OP);
        TEMPLATE_REGISTRY.register(16029, DELTA_OP);
        TEMPLATE_REGISTRY.register(16030, TAIL_OP);
        TEMPLATE_REGISTRY.register(16031, FOREIGN_INSTR);
        TEMPLATE_REGISTRY.register(16032, ELEMENT);
        TEMPLATE_REGISTRY.register(16033, TEXT);
        MessageTemplate[] templates = TEMPLATE_REGISTRY.getTemplates();
        int i = 0;
        while (i < templates.length) {
            SessionControlProtocol_1_1.setNamespace(templates[i]);
            ++i;
        }
        CLOSE = SessionControlProtocol_1_1.createFastAlertMessage(SessionConstants.CLOSE);
    }

    protected SessionControlProtocol_1_1() {
        messageHandlers.put(FAST_ALERT_TEMPLATE, ALERT_HANDLER);
        messageHandlers.put(TEMPLATE_DEFINITION, new SessionMessageHandler(){

            public void handleMessage(Session session, Message message) {
                MessageTemplate template = SessionControlProtocol_1_1.this.createTemplateFromMessage(message, session.in.getTemplateRegistry());
                session.addDynamicTemplateDefinition(template);
                if (message.isDefined("TemplateId")) {
                    session.registerDynamicTemplate(template.getQName(), message.getInt("TemplateId"));
                }
            }
        });
        messageHandlers.put(TEMPLATE_DECLARATION, new SessionMessageHandler(){

            public void handleMessage(Session session, Message message) {
                session.registerDynamicTemplate(SessionControlProtocol_1_1.this.getQName(message), message.getInt("TemplateId"));
            }
        });
    }

    public static ConversionContext createInitialContext() {
        ConversionContext context = new ConversionContext();
        context.addFieldInstructionConverter(new ScalarConverter());
        context.addFieldInstructionConverter(new SequenceConverter());
        context.addFieldInstructionConverter(new GroupConverter());
        context.addFieldInstructionConverter(new DynamicTemplateReferenceConverter());
        context.addFieldInstructionConverter(new StaticTemplateReferenceConverter());
        context.addFieldInstructionConverter(new ComposedDecimalConverter());
        context.addFieldInstructionConverter(new VariableLengthInstructionConverter());
        return context;
    }

    protected QName getQName(Message message) {
        String name = message.getString("Name");
        String ns = message.getString("Ns");
        return new QName(name, ns);
    }

    public void configureSession(Session session) {
        this.registerSessionTemplates(session.in.getTemplateRegistry());
        this.registerSessionTemplates(session.out.getTemplateRegistry());
        session.in.addMessageHandler(FAST_RESET_TEMPLATE, RESET_HANDLER);
        session.out.addMessageHandler(FAST_RESET_TEMPLATE, RESET_HANDLER);
    }

    public void registerSessionTemplates(TemplateRegistry registry) {
        registry.registerAll(TEMPLATE_REGISTRY);
    }

    public Session connect(String senderName, Connection connection, TemplateRegistry inboundRegistry, TemplateRegistry outboundRegistry, MessageListener messageListener, SessionListener sessionListener) {
        Session session = new Session(connection, this, inboundRegistry, outboundRegistry);
        this.configureSession(session);
        session.out.writeMessage(this.createHelloMessage(senderName));
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Message message = session.in.readMessage();
        session.setMessageHandler(messageListener);
        String serverName = message.getString(1);
        String vendorId = message.isDefined(2) ? message.getString(2) : "unknown";
        session.setClient(new BasicClient(serverName, vendorId));
        return session;
    }

    public void onError(Session session, ErrorCode code, String message) {
        session.out.writeMessage(SessionControlProtocol_1_1.createFastAlertMessage(code));
    }

    public Session onNewConnection(String serverName, Connection connection) {
        Session session = new Session(connection, this, TemplateRegistry.NULL, TemplateRegistry.NULL);
        Message message = session.in.readMessage();
        String clientName = message.getString(1);
        String vendorId = message.isDefined(2) ? message.getString(2) : "unknown";
        session.setClient(new BasicClient(clientName, vendorId));
        session.out.writeMessage(this.createHelloMessage(serverName));
        return session;
    }

    public Message createHelloMessage(String senderName) {
        Message message = new Message(FAST_HELLO_TEMPLATE);
        message.setString(1, senderName);
        message.setString(2, "http://openfast.org/OpenFAST/1.1");
        return message;
    }

    public static Message createFastAlertMessage(ErrorCode code) {
        Message alert = new Message(FAST_ALERT_TEMPLATE);
        alert.setInteger(1, code.getSeverity().getCode());
        alert.setInteger(2, code.getCode());
        alert.setString(4, code.getDescription());
        return alert;
    }

    public void handleMessage(Session session, Message message) {
        if (!messageHandlers.containsKey(message.getTemplate())) {
            return;
        }
        ((SessionMessageHandler)messageHandlers.get(message.getTemplate())).handleMessage(session, message);
    }

    public boolean isProtocolMessage(Message message) {
        if (message == null) {
            return false;
        }
        return messageHandlers.containsKey(message.getTemplate());
    }

    public boolean supportsTemplateExchange() {
        return true;
    }

    public Message createTemplateDeclarationMessage(MessageTemplate messageTemplate, int templateId) {
        Message declaration = new Message(TEMPLATE_DECLARATION);
        AbstractFieldInstructionConverter.setName(messageTemplate, declaration);
        declaration.setInteger("TemplateId", templateId);
        return declaration;
    }

    public Message createTemplateDefinitionMessage(MessageTemplate messageTemplate) {
        Message templateDefinition = GroupConverter.convert(messageTemplate, new Message(TEMPLATE_DEFINITION), this.initialContext);
        int reset = messageTemplate.hasAttribute(RESET_PROPERTY) ? 1 : 0;
        templateDefinition.setInteger("Reset", reset);
        return templateDefinition;
    }

    public MessageTemplate createTemplateFromMessage(Message templateDef, TemplateRegistry registry) {
        String name = templateDef.getString("Name");
        String namespace = "";
        if (templateDef.isDefined("Ns")) {
            namespace = templateDef.getString("Ns");
        }
        Field[] fields = GroupConverter.parseFieldInstructions(templateDef, registry, this.initialContext);
        MessageTemplate group = new MessageTemplate(new QName(name, namespace), fields);
        if (templateDef.isDefined("TypeRef")) {
            GroupValue typeRef = templateDef.getGroup("TypeRef");
            String typeRefName = typeRef.getString("Name");
            String typeRefNs = "";
            if (typeRef.isDefined("Ns")) {
                typeRefNs = typeRef.getString("Ns");
            }
            group.setTypeReference(new QName(typeRefName, typeRefNs));
        }
        if (templateDef.isDefined("AuxId")) {
            group.setId(templateDef.getString("AuxId"));
        }
        return group;
    }

    private static Field u32(String name) {
        return new Scalar(SessionControlProtocol_1_1.qualify(name), Type.U32, Operator.NONE, null, false);
    }

    private static Field dict(String name, Type type, boolean optional, String dictionary) {
        Scalar scalar = new Scalar(SessionControlProtocol_1_1.qualify(name), type, Operator.COPY, null, optional);
        scalar.setDictionary(dictionary);
        return scalar;
    }

    private static QName qualify(String name) {
        return new QName(name, NAMESPACE);
    }

    private static Field unicodeopt(String name) {
        return new Scalar(SessionControlProtocol_1_1.qualify(name), Type.UNICODE, Operator.NONE, null, true);
    }

    private static Field unicode(String name) {
        return new Scalar(SessionControlProtocol_1_1.qualify(name), Type.UNICODE, Operator.NONE, null, false);
    }

    private static Field u32opt(String name) {
        return new Scalar(SessionControlProtocol_1_1.qualify(name), Type.U32, Operator.NONE, null, true);
    }

    private static void setNamespace(Group group) {
        group.setChildNamespace(NAMESPACE);
        Field[] fields = group.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] instanceof Group) {
                SessionControlProtocol_1_1.setNamespace((Group)fields[i]);
            }
            ++i;
        }
    }

    public Message getCloseMessage() {
        return CLOSE;
    }
}

