/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.CacheKey;
import com.portfolioeffect.quant.client.portfolio.PortfolioCache;
import com.portfolioeffect.quant.client.portfolio.PortfolioData;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.Console;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class PortfolioContainer {
    static final int MAX_PDF_POINTS = 300;
    static final int NUMBER_OF_TRIES = 20;
    boolean isDebug = false;
    PortfolioData portfolioData = new PortfolioData();
    HashMap<String, ArrayCache> symbolUserDataMap;
    HashMap<String, ArrayCache> symbolUserDataTimeMap;
    Set<String> userData;
    ClientConnection clientConnection;
    ArrayList<String> batchMetricsPosition;
    ArrayList<String> batchMetricPortfolioKeys;
    ArrayList<String> batchMetricPositionKeys;
    ArrayList<String> batchMetricsPortfolio;
    ArrayList<String> batchMetricsPositionOld;
    ArrayList<String> batchMetricPortfolioKeysOld;
    ArrayList<String> batchMetricPositionKeysOld;
    ArrayList<String> batchMetricsPortfolioOld;
    String batchMetricKey = null;
    long[] samplingTimes = null;
    boolean isBatchStart = false;
    boolean isMultiBatch = true;
    boolean isBatchOn = true;
    List<CacheKey> cachedValueList;
    PortfolioCache portfolioCache;
    int windowLength = 23400;
    private ReentrantLock lock;

    protected void finalize() throws Throwable {
        this.symbolUserDataMap.clear();
        this.symbolUserDataTimeMap.clear();
        this.clearCache();
        this.portfolioData = null;
        this.portfolioCache = null;
        super.finalize();
    }

    public void del() throws Throwable {
        this.finalize();
    }

    public PortfolioContainer(ClientConnection clientConnection) {
        this.portfolioCache = new PortfolioCache();
        this.clientConnection = clientConnection;
        this.symbolUserDataMap = new HashMap();
        this.symbolUserDataTimeMap = new HashMap();
        this.cachedValueList = new ArrayList<CacheKey>();
        this.userData = new HashSet<String>();
        this.batchMetricsPosition = null;
        this.batchMetricsPortfolio = null;
        this.lock = new ReentrantLock();
    }

    public PortfolioContainer(PortfolioContainer portfolio) throws IOException {
        this.portfolioData = new PortfolioData(portfolio.portfolioData);
        this.clientConnection = portfolio.clientConnection;
        this.symbolUserDataMap = new HashMap();
        this.symbolUserDataTimeMap = new HashMap();
        this.cachedValueList = new ArrayList<CacheKey>();
        this.userData = new HashSet<String>();
        this.isDebug = portfolio.isDebug;
        this.portfolioCache = new PortfolioCache();
        for (String symbol : portfolio.userData) {
            this.addUserData(symbol, portfolio.symbolUserDataMap.get(symbol).getDoubleArray(), portfolio.symbolUserDataTimeMap.get(symbol).getLongArray());
        }
        this.batchMetricsPosition = null;
        this.batchMetricsPortfolio = null;
        this.batchMetricPortfolioKeys = null;
        this.batchMetricPositionKeys = null;
        this.windowLength = portfolio.windowLength;
        this.isMultiBatch = portfolio.isMultiBatch;
        this.lock = new ReentrantLock();
    }

    public void clearCache() {
        for (CacheKey key : this.cachedValueList) {
            try {
                this.portfolioCache.remove(key);
            }
            catch (IOException e) {
                this.processException(e);
            }
        }
        this.cachedValueList = new ArrayList<CacheKey>();
    }

    public Metric addUserData(String dataName, double[] value, long[] timeMillSec) {
        this.portfolioData.getPriceID().put(dataName, this.portfolioData.getNextDataId());
        if (value.length == 0) {
            return new Metric("Wrong length of data vector.");
        }
        if (timeMillSec.length == 0) {
            return new Metric("Wrong length of time vector.");
        }
        if (value.length != timeMillSec.length) {
            return new Metric("Length of data and time vector must be the same.");
        }
        this.removeUserData(dataName);
        try {
            ArrayCache cashData = new ArrayCache(value);
            this.symbolUserDataMap.put(dataName, cashData);
            ArrayCache cashTime = new ArrayCache(timeMillSec);
            this.symbolUserDataTimeMap.put(dataName, cashTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.userData.add(dataName);
        this.clearCache();
        return new Metric();
    }

    public void removeUserData(String symbol) {
        if (this.userData.contains(symbol)) {
            this.userData.remove(symbol);
            this.symbolUserDataMap.remove(symbol);
            this.symbolUserDataTimeMap.remove(symbol);
        }
        this.clearCache();
    }

    private Metric processException(IOException e) {
        if (this.isDebug) {
            Console.writeStackTrace(e);
        }
        if (e.getMessage() != null) {
            return new Metric(e.getMessage());
        }
        return new Metric("Error while working with the local file system");
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public void setClientConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public void makeAsincConnection(boolean isMultiplex) {
        this.lock();
        ClientConnection client = new ClientConnection(this.clientConnection);
        client.makeAsincConnection(isMultiplex);
        this.clientConnection = client;
        this.unlock();
    }

    public void makeSincConnection(boolean isMultiplex) {
        this.lock();
        ClientConnection client = new ClientConnection(this.clientConnection);
        client.makeSincConnection();
        if (!isMultiplex) {
            this.clientConnection.stop();
        }
        this.clientConnection = client;
        this.unlock();
    }
}

