% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminated_postcode.R
\name{terminated_postcode}
\alias{terminated_postcode}
\title{Terminated postcode lookup}
\usage{
terminated_postcode(postcode)
}
\arguments{
\item{postcode}{A string. Terminated UK postcode.}
}
\value{
A data frame with data about terminated postcode. NULL if postcode is active.
\itemize{
\item \code{postcode} Postcode. All currently terminated postcodes within
the United Kingdom, the Channel Islands and the Isle of Man,
received every 3 months from Royal Mail. 2, 3 or 4-character outward code,
single space and 3-character inward code.
\item \code{year_terminated} Termination year.
Year of termination of a postcode.
\item \code{month_terminated} Termination month.
Month of termination of a postcode. 1-January, 2-February, ..., 12-December.
\item \code{longitude} Longitude.
The WGS84 longitude given the Postcode's national grid reference.
\item \code{latitude} Latitude.
The WGS84 latitude given the Postcode's national grid reference.
}

See
\url{https://postcodes.io/docs} for more details.
}
\description{
Returns month and year if a postcode was terminated or is no longer active.
}
\examples{
\donttest{
terminated_postcode("EC1Y 8LX") # exisitng postcode
terminated_postcode("E1W 1UU") # terminated
}

}
