% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerful.seceig.tri.R
\name{powerful.seceig.tri}
\alias{powerful.seceig.tri}
\title{Tridiagonal matrix next to the maximal eigenpair}
\usage{
powerful.seceig.tri(a, b, digit.thresh = 6)
}
\arguments{
\item{a}{The lower diagonal vector.}

\item{b}{The upper diagonal vector.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating eigenfunction of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Calculate the next to maximal eigenpair for the tridiagonal matrix by
Thomas algorithm.
}
\examples{
nn = 8
a = c(1:(nn - 1))^2
b = c(1:(nn - 1))^2
powerful.seceig.tri(a, b, digit.thresh = 6)
}
