% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MCODE.R
\name{mcode}
\alias{mcode}
\title{MCODE network clustering}
\usage{
mcode(graph, vwp = 0.5, haircut = FALSE, fluff = FALSE, fdt = 0.8,
  loops = TRUE)
}
\arguments{
\item{graph}{An igraph object.}

\item{vwp}{Vertex weight percentage. Default value is \code{0.5}.}

\item{haircut}{Boolean value, whether to remove singly-connected nodes from clusters (\code{TRUE}) or not (\code{FALSE}).}

\item{fluff}{Boolean value, whether to spand cluster cores by one neighbour shell outwards (\code{TRUE}) or not (\code{FALSE}).}

\item{fdt}{Cluster density cutoff. Default value is \code{0.8}.}

\item{loops}{Boolean value, whether to include self-loops (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A list of clusters.
}
\description{
Clustering of the network using the MCODE method.
}
\examples{
nlocal<-data.frame(c("DVL1","DVL2","DVL3"))
net<-construction(input=nlocal,db="HPRD",species="human",ID.type="Gene symbol",hierarchy=1)
mcode(net,vwp=0.9,haircut=TRUE,fluff=TRUE,fdt=0.1)
}
\references{
Bader GD, Hogue CW. An automated method for finding molecular complexes in large protein interaction networks. BMC Bioinformatics. 2003 Jan 13;4(1):2.
}
\seealso{
\code{\link{cluster}}
}

