% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.sgpv.R
\name{predict.sgpv}
\alias{predict.sgpv}
\title{Prediction using the fitted model}
\usage{
\method{predict}{sgpv}(object, newx, ...)
}
\arguments{
\item{object}{An \code{sgpv} objectect}

\item{newx}{Prediction data set}

\item{...}{Other \code{predict} arguments}
}
\value{
Predicted values
}
\description{
S3 method \code{predict} for an object of class \code{sgpv}
}
\examples{

# load the package
library(ProSGPV)

# prepare the data
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

# run one-stage algorithm
out.sgpv.1 <- pro.sgpv(x = x, y = y, stage = 1)

predict(out.sgpv.1)
}
