% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{rawToCharNull}
\alias{rawToCharNull}
\title{Convert raw vectors into a character string}
\usage{
rawToCharNull(raw_dat)
}
\arguments{
\item{raw_dat}{A vector of class \code{raw} to be converted into a \code{character}.}
}
\value{
A \code{character} string based on the \code{raw} data
}
\description{
A function that converts \code{raw} data into a \code{character} string.
}
\details{
The function \code{\link{rawToChar}} will fail on vectors of \code{raw} data
with embedded \code{0x00} data. This function will not fail on embedded \code{0x00} values.
Instead, it will replace embedded \code{0x00} data with white spaces. Note that
leading and trailing \code{0x00} data will be omitted from the result.
}
\examples{
## generate some raw data with an embedded 0x00:
some.raw.data <- as.raw(c(0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x00,
                          0x77, 0x6f, 0x72, 0x6c, 0x64, 0x21))
\dontrun{
## this will fail:
try(rawToChar(some.raw.data))
}

## this will succeed:
rawToCharNull(some.raw.data)
}
\author{
Pepijn de Vries
}
\seealso{
Other character.operations: \code{\link{as.character}},
  \code{\link{as.character,PTCell-method}},
  \code{\link{as.character,PTPattern-method}},
  \code{\link{as.character,PTTrack-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{periodToChar}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{as.raw,PTCell-method}},
  \code{\link{as.raw,PTPattern-method}},
  \code{\link{as.raw,PTTrack-method}},
  \code{\link{as.raw<-}},
  \code{\link{as.raw<-,PTCell,raw-method}},
  \code{\link{as.raw<-,PTPattern,matrix-method}},
  \code{\link{as.raw<-,PTTrack,matrix-method}};
  \code{\link{hiNybble}}, \code{\link{loNybble}},
  \code{\link{nybble}}; \code{\link{nybbleToSignedInt}};
  \code{\link{rawToSignedInt}};
  \code{\link{rawToUnsignedInt}};
  \code{\link{signedIntToNybble}};
  \code{\link{signedIntToRaw}};
  \code{\link{unsignedIntToRaw}}
}

